<?php

namespace Modules\Appointment\Entities;

use App\Models\Language;
use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\CourseLevel;

class InstructorTeachingLanguage extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function language()
    {
        return $this->belongsTo(Language::class, 'language_id', 'id')->withDefault();
    }
    public function level()
    {
        return $this->belongsTo(CourseLevel::class, 'level_id', 'id')->withDefault();
    }
}
