<?php

namespace Modules\Appointment\Http\Requests;

use Illuminate\Validation\Rule;
use App\Traits\ValidationMessage;
use Illuminate\Foundation\Http\FormRequest;

class TimeSlotRequest extends FormRequest
{
    use ValidationMessage;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => ['sometimes', 'nullable', Rule::unique('time_slots', 'title')
                ->where('lms_id', auth()->user()->id)->ignore($this->id)],
            'start_time' => 'required', 'date_format:h:i A',
            'end_time' => ['sometimes', 'nullable', 'after:start_time'],
        ];

    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
