<?php

use Illuminate\Support\Facades\Route;

Route::get('/appointment', 'FrontendAppointmentController@index')->name('appointment');
Route::get('/appointment/tutor-finder', 'FrontendAppointmentController@instructors')->name('appointment.instructors');
Route::get('/tutor-finder/{slug}', 'FrontendAppointmentController@categoryInstructor')->name('category.tutor');
Route::get('/appointment/timezone/user', 'FrontendAppointmentController@timeZone')->name('appointment.timeZone');
Route::get('/appointment/timezone/change-calendar', 'FrontendAppointmentController@calendarChange')
    ->name('appointment.change-calendar');
Route::get('/tutor-finder', 'FrontendAppointmentController@instructors')->name('appointment.instructors');
Route::post('/make-place-order', 'BookingController@makePlaceOrder')->name('appointment.makePlaceOrder');

Route::post('/appointment/booking/store', 'BookingController@store')->name('appointment.booking.store');
Route::get('/appointment/book-trail-lesson/{slug}', 'BookingController@bookTrailLesson')->name('book-trail-lesson');

Route::group(['prefix' => 'appointment', 'as' => 'appointment.'], function ($routes) {

    $routes->post('/submitReview', 'ReviewController@store')->name('submitReview');
    $routes->get('/tutor', 'FrontendAppointmentController@index')->name('index');
    $routes->get('/tutor-list', 'FrontendAppointmentController@instructors')->name('instructors');
    $routes->get('/checkout', 'FrontendAppointmentController@checkout')->name('checkout');
    $routes->get('/tutor/{slug}', 'FrontendAppointmentController@instructor')->name('instructor');

    $routes->group(['prefix' => 'become-tutor', 'as' => 'become-tutor.'], function ($routes) {
        $routes->get('/', 'BecomeTutorController@index')->name('index');
        $routes->get('/create', 'BecomeTutorController@create')->name('create');
        $routes->post('/', 'BecomeTutorController@store')->name('store');
        $routes->get('/show/{id}', 'BecomeTutorController@show')->name('show');
        $routes->get('/{id}/edit', 'BecomeTutorController@edit')->name('edit');
        $routes->put('/{id}', 'BecomeTutorController@update')->name('update');
        $routes->get('/delete/{id}', 'BecomeTutorController@destroy')->name('destroy');
    });
    //post-request
    $routes->group(['prefix' => 'post', 'as' => 'post.'], function ($routes) {
        $routes->get('/', 'TutorPostController@index')->name('index');
        $routes->get('/list', 'TutorPostController@list')->name('list');
        $routes->get('/category/instructor', 'TutorPostController@categoryInstructor')
            ->name('category-instructor');
        $routes->post('/', 'TutorPostController@store')->name('store');
        $routes->post('/share-instructor', 'TutorPostController@shareInstructorStore')->name('share-instructor.store');
        $routes->get('/share-instructor/{id}', 'TutorPostController@shareInstructor')->name('share-instructor');
        $routes->get('/delete/{id}', 'TutorPostController@destroy')->name('destroy');
    });

});

Route::group(['prefix' => 'appointment', 'as' => 'appointment.', 'middleware' => ['auth']], function ($routes) {

    // time slot
    $routes->group(['prefix' => 'time-slot', 'as' => 'time-slot.'], function ($routes) {
        $routes->get('/', 'TimeSlotController@index')->name('index');
        $routes->get('/create', 'TimeSlotController@create')->name('create');
        $routes->post('/', 'TimeSlotController@store')->name('store');
        $routes->get('/show/{id}', 'TimeSlotController@show')->name('show');
        $routes->get('/{id}/edit', 'TimeSlotController@edit')->name('edit');
        $routes->put('/{id}', 'TimeSlotController@update')->name('update');
        $routes->get('/delete/{id}', 'TimeSlotController@destroy')->name('destroy');
    });
    // schedule
    $routes->group(['prefix' => 'schedule', 'as' => 'schedule.'], function ($routes) {
        $routes->get('/', 'ScheduleController@index')->name('index');
        $routes->get('/next-week/{next_date}', 'ScheduleController@nextWeek')->name('next-date');
        $routes->get('/create', 'ScheduleController@create')->name('create');
        $routes->post('/store', 'ScheduleController@store')->name('store');
        $routes->get('/show/{id}', 'ScheduleController@show')->name('show');
        $routes->get('/{id}/edit', 'ScheduleController@edit')->name('edit');
        $routes->put('/update/{id}', 'ScheduleController@update')->name('update');
        $routes->get('/delete/{id}', 'ScheduleController@destroy')->name('destroy');
        $routes->post('/search', 'ScheduleController@searchInstructorSchedule')->name('search.instructor-schedule');
        $routes->get('/{slug}', 'ScheduleController@instructorSchedule')->name('instructor-schedule');
        $routes->get('/ajax/user-schedule', 'ScheduleController@getUserSchedule')->name('user-schedule');
        $routes->get('/ajax/time-slot', 'ScheduleController@getUserTimeSlot')->name('user-time-slot');
    });
    //booking
    $routes->group(['prefix' => 'booking', 'as' => 'booking.'], function ($routes) {
        $routes->get('/', 'BookingController@index')->name('index');
        $routes->post('/', 'BookingController@index')->name('pending');
        $routes->get('/user', 'BookingController@bookedUser')->name('user');
        $routes->post('/user', 'BookingController@bookedUser')->name('user.search');
        $routes->post('/share-link', 'BookingController@shareLink')->name('shareLink');
        $routes->get('/trail-lesson', 'BookingController@trailLessonList')->name('trail-lesson');
        $routes->post('/trail-lesson', 'BookingController@trailLessonList')->name('trail-lesson.search');
        $routes->get('/trail/lesson/delete/{id}', 'BookingController@trailLessonDelete')->name('trail-lesson.delete');
        $routes->post('/trail-lesson/set-schedule', 'ScheduleController@setSchedule')->name('set-schedule');
        $routes->get('/approve/{approve_id}', 'BookingController@approve')->name('approve');
        $routes->get('/reject/{reject_id}', 'BookingController@reject')->name('reject');

    });
    //settings
    $routes->group(['prefix' => 'settings', 'as' => 'settings.'], function ($routes) {
        $routes->get('/', 'SettingsController@index')->name('index');
        $routes->post('/update/{id}', 'SettingsController@update')->name('update');

    });
    $routes->group(['prefix' => 'instructor', 'as' => 'instructor.'], function ($routes) {
        $routes->get('/', 'InstructorController@index')->name('index');
        $routes->get('/education', 'InstructorController@education')
            ->name('education');
        $routes->get('/create', 'InstructorController@create')->name('create');
        $routes->post('/', 'InstructorController@store')->name('store');
        $routes->get('/{id}/edit', 'InstructorController@edit')->name('edit');
        $routes->put('/{id}', 'InstructorController@update')->name('update');
        $routes->get('/delete/{id}', 'InstructorController@destroy')->name('destroy');
        $routes->post('/specialist-subject-delete', 'SubjectController@specialistSubjectDelete')
            ->name('specialist-subject-delete');
    });
    //page builder
    $routes->group(['prefix' => 'page', 'as' => 'page.'], function ($routes) {
        $routes->get('/', 'PageBuilderController@index')->name('index');
        $routes->get('/create', 'PageBuilderController@create')->name('create');
        $routes->post('/', 'PageBuilderController@store')->name('store');
        $routes->get('/show/{id}', 'PageBuilderController@show')->name('show');
        $routes->get('/design/{id}', 'PageBuilderController@design')->name('design');
        $routes->get('/{id}/edit', 'PageBuilderController@edit')->name('edit');
        $routes->put('/{id}', 'PageBuilderController@update')->name('update');
        $routes->put('/design/{id}', 'PageBuilderController@designUpdate')->name('design.update');
        $routes->get('/delete/{id}', 'PageBuilderController@destroy')->name('destroy');
        $routes->get('snippet', 'PageBuilderController@snippet')->name('snippet');
        $routes->get('tutor-finder', 'PageBuilderController@tutorFinder')->name('tutor-finder');
    });

    $routes->post('/save-flat-commission', 'CommissionController@flatCommissionStore')->name('save-flat-commission');

    //become-tutor


});
// for student
Route::group(['middleware' => ['student']], function () {
    Route::get('my-appointment', 'MyAppointmentController@index')->name('myAppointment');
    Route::get('appointment/my-wishlist', 'MyAppointmentController@myWishList')->name('myWishlist');
    Route::get('appointment/my-wishlist/{instructor_slug}', 'MyAppointmentController@storeWishList')->name('store.wishlist');
    Route::get('change-calendar', 'MyAppointmentController@change')->name('change-calendar');
});
