<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderPackageDetailsTable extends Migration
{
    public function up()
    {
        Schema::create('order_package_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id');
            $table->unsignedBigInteger('seller_id');
            $table->unsignedBigInteger('is_store');
            $table->unsignedBigInteger('course_id');
            $table->string('package_code')->nullable();
            $table->unsignedInteger('number_of_product');
            $table->double('shipping_cost')->nullable();
            $table->string('shipping_date')->nullable();
            $table->unsignedBigInteger('shipping_method')->nullable();
            $table->unsignedInteger('is_cancelled')->default(0);
            $table->unsignedInteger('cancel_reason_id')->nullable();
            $table->unsignedInteger('is_reviewed')->default(0);
            $table->unsignedBigInteger('delivery_status')->default(1);
            $table->unsignedBigInteger('last_updated_by')->nullable();
            $table->boolean('gst_claimed')->default(0);
            $table->double('tax_amount')->default(0)->nullable();
            $table->string('carrier_order_id')->nullable();
            $table->string('carrier_id')->nullable();
            $table->string('shipped_by')->nullable();
            $table->text('carrier_response')->nullable();
            $table->unsignedBigInteger('pickup_point_id')->nullable()->default(1);
            $table->boolean('is_paid')->default(0);
            $table->float('weight')->nullable();
            $table->float('length')->nullable();
            $table->float('breadth')->nullable();
            $table->float('height')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('order_package_details');
    }
}
