<?php

namespace Modules\Store\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Setting\Entities\UsedMedia;

class ProductCarrier extends Model
{
    protected $fillable = [
        'name',
        'logo',
        'status',
        'type',
        'slug',
        'tracking_url',
        'created_by',
    ];

    public function shippingMethods()
    {
        return $this->hasMany(ShippingMethod::class, 'carrier_id', 'id');
    }

    public function carrierConfig()
    {
        $user_id = getParentSellerId();
        return $this->hasOne(SellerWiseCarrierConfig::class, 'carrier_id')->where('seller_id', $user_id);
    }

    public function carrierConfigFrontend()
    {
        return $this->hasOne(SellerWiseCarrierConfig::class, 'carrier_id');
    }

    public function logo_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'logo');
    }

}
