@extends('backend.master')
@section('styles')
    <style>
        .dashed {
            margin-top: 1rem;
            margin-bottom: 1rem;
            border: 0;
            border-top: 1px dashed var(--gradient_1);
        }
    </style>
@endsection
@section('mainContent')

    {!! generateBreadcrumb() !!}

    <link rel="stylesheet" href="{{ asset('public/backend/css/daterangepicker.css') }}">
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12 mb_30">
                    <div class="white-box">
                        <form action="{{route('store.shiporder.index')}}" method="get">
                            <div class="row">
                                <div class="col-lg-3">
                                    <div class="primary_input mb-15 date_range">
                                        <div class="primary_datepicker_input filter">
                                            <label class="primary_input_label" for="">{{__('common.Date')}}</label>
                                            <div class="g-0  input-right-icon">
                                                <input placeholder="{{__('common.Date')}}" readonly
                                                       class="primary_input_field date_range_input" type="text"
                                                       name="date_range_filter" value="">
                                                <button class="" type="button">
                                                    <i class="fa fa-refresh" id="reset-date-filter"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="carrier">{{ __('product.carrier')}} </label>
                                        <select class="primary_select mb-15" id="carrier" name="carrier">
                                            <option value="">{{__('common.select_one')}}</option>
                                            @foreach($carriers as $carrier)
                                                <option
                                                    {{$carrier->id == $f_carrier ? 'selected' :''}} value="{{$carrier->id}}">{{$carrier->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="shipping_method">{{ __('product.method')}} </label>
                                        <select class="primary_select mb-15" id="shipping_method"
                                                name="shipping_method">
                                            <option value="">{{__('common.select_one')}}</option>
                                            @foreach($shipping_methods as $method)
                                                <option
                                                    {{$method->id == $shipping_method ? 'selected' :''}} value="{{$method->id}}">{{$method->method_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="package_code"> {{__("product.tracking_id")}}</label>
                                        <input value="{{!empty($package_code) ? $package_code :''}}"
                                               class="primary_input_field" name="package_code" id="package_code"
                                               placeholder=" {{__("product.tracking_id")}}" type="text">
                                    </div>
                                </div>
                                <div class="col-lg-12 text-center">
                                    <div class="d-flex justify-content-center mb-4">
                                        <button class="primary-btn  me-2  fix-gr-bg  " type="submit"><i
                                                class="ti-search"></i>{{ __('common.Search') }}</button>
                                        <a href="{{route('store.shiporder.index')}}"
                                           class="primary-btn    fix-gr-bg" type="button"><i
                                                class="ti-reload"></i>{{ __('product.Reset') }}</a>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <div class="row">
                            <div class="col-lg-12">
                                <label class="primary_input_label" for="">{{__('product.set_pickup_location')}}</label>
                                <ul class="permission_list sms_list">
                                    @foreach($pickup_locations as $location)
                                        <li>
                                            <label class="primary_checkbox d-flex mr-12 ">
                                                <input
                                                    {{pickupLocationData('id') == $location->id ? 'checked' :'' }} name="pickup_location"
                                                    class="pickup_location" type="radio" id="set_pickup_location"
                                                    value="{{$location->id}}">
                                                <span class="checkmark"></span>
                                            </label>
                                            <p>{{$location->pickup_location}}</p>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="white-box">
                        <div class="main-title">
                            <h3 class="mb-20" id="page_title">{{__('product.Shipping Orders')}}</h3>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th>{{__('common.Sl')}}</th>
                                            <th>{{__('common.date')}}</th>
                                            <th>{{__('product.order_id')}}</th>
                                            <th>{{__('product.tracking_id')}}</th>
                                            <th>{{__('product.shipping_method')}}</th>
                                            <th>{{__('product.carrier')}}</th>
                                            <th>{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($orders as $key => $row)
                                            <tr>

                                                <td>{{ $key+1 }}</td>
                                                <td>{{ showDate($row->created_at) }}</td>
                                                <td>{{ $row->order->order_number }}</td>
                                                <td>{{ $row->package_code }}</td>
                                                <td>{{$row->shipping->method_name}}</td>
                                                <td>{{$row->carrier->name}}</td>
                                                @php
                                                    $packaging_info = false;
                                                    if($row->length && $row->breadth && $row->height && $row->weight){
                                                      $packaging_info = true;
                                                    }

                                                @endphp

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{__('common.select')}}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">

                                                            <a target="_blank"
                                                               href="{{route('shipping.label_generate',$row->id)}}"
                                                               class="dropdown-item">{{__('product.label')}}</a>

                                                            <a target="_blank"
                                                               href="{{route('shipping.invoice_generate',$row->id)}}"
                                                               class="dropdown-item">{{__('product.invoice')}}</a>


                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="append_html"></div>
        <input type="hidden" value="{{count($orders)}}" id="total_order">
        <input type="hidden" value="{{route('shipping.single_order_method_change',':id')}}"
               id="shipping_method_change_url">
    </section>
@endsection
@push('scripts')
    <script src="{{asset('Modules/Store/Resources/assets/js/shipping.js')}}"></script>
    <script src="{{asset('Modules/Store/Resources/assets/js/shipping_method_change.js')}}"></script>
    <script src="{{asset('public/backend/js/daterangepicker.min.js')}}"></script>

    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {

                $(document).on('change', '#b_business_country', function (event) {
                    let country = $('#b_business_country').val();

                    $('.preloader').removeClass('d-none');
                    if (country) {
                        let base_url = $('#url').val();
                        let url = base_url + '/seller/profile/get-state?country_id=' + country;

                        $('#b_business_state').empty();

                        $('#b_business_state').append(
                            `<option value="" disabled selected>{{__('common.select_one')}}</option>`
                        );
                        $('#b_business_state').niceSelect('update');
                        $('#b_business_city').empty();
                        $('#b_business_city').append(
                            `<option value="" disabled selected>{{__('common.select_one')}}</option>`
                        );
                        $('#b_business_city').niceSelect('update');
                        $.get(url, function (data) {

                            $.each(data, function (index, stateObj) {
                                $('#b_business_state').append('<option value="' + stateObj.id + '">' + stateObj.name + '</option>');
                            });

                            $('#b_business_state').niceSelect('update');
                            $('.preloader').addClass('d-none');
                        });
                    }
                });
                $(document).on('change', '#b_business_state', function (event) {
                    let state = $('#b_business_state').val();

                    $('.preloader').removeClass('d-none');
                    if (state) {
                        let base_url = $('#url').val();
                        let url = base_url + '/seller/profile/get-city?state_id=' + state;

                        $('#b_business_city').empty();

                        $('#b_business_city').append(
                            `<option value="" disabled selected>{{__('common.select_one')}}</option>`
                        );
                        $('#b_business_city').niceSelect('update');

                        $.get(url, function (data) {

                            $.each(data, function (index, cityObj) {
                                $('#b_business_city').append('<option value="' + cityObj.id + '">' + cityObj.name + '</option>');
                            });

                            $('#b_business_city').niceSelect('update');
                            $('.preloader').addClass('d-none');
                        });
                    }
                });

                $(document).on('change', '#s_business_country', function (event) {
                    let country = $('#s_business_country').val();

                    $('.preloader').removeClass('d-none');
                    if (country) {
                        let base_url = $('#url').val();
                        let url = base_url + '/seller/profile/get-state?country_id=' + country;

                        $('#s_business_state').empty();

                        $('#s_business_state').append(
                            `<option value="" disabled selected>{{__('common.select_one')}}</option>`
                        );
                        $('#s_business_state').niceSelect('update');
                        $('#s_business_city').empty();
                        $('#s_business_city').append(
                            `<option value="" disabled selected>{{__('common.select_one')}}</option>`
                        );
                        $('#s_business_city').niceSelect('update');
                        $.get(url, function (data) {

                            $.each(data, function (index, stateObj) {
                                $('#s_business_state').append('<option value="' + stateObj.id + '">' + stateObj.name + '</option>');
                            });

                            $('#s_business_state').niceSelect('update');
                            $('.preloader').addClass('d-none');
                        });
                    }
                });
                $(document).on('change', '#s_business_state', function (event) {
                    let state = $('#s_business_state').val();

                    $('.preloader').removeClass('d-none');
                    if (state) {
                        let base_url = $('#url').val();
                        let url = base_url + '/seller/profile/get-city?state_id=' + state;

                        $('#s_business_city').empty();

                        $('#s_business_city').append(
                            `<option value="" disabled selected>{{__('common.select_one')}}</option>`
                        );
                        $('#s_business_city').niceSelect('update');

                        $.get(url, function (data) {

                            $.each(data, function (index, cityObj) {
                                $('#s_business_city').append('<option value="' + cityObj.id + '">' + cityObj.name + '</option>');
                            });

                            $('#s_business_city').niceSelect('update');
                            $('.preloader').addClass('d-none');
                        });
                    }
                });

                $(document).on('change', '#shipping_carrier', function (event) {
                    event.preventDefault();
                    $('.preloader').removeClass('d-none');
                    let carrier = $(this).val();
                    let url = $('#shipping_carrier_change').val();
                    url = url.replace(':id', carrier);
                    let data = {
                        "_token": "{{csrf_token()}}",
                        "carrier_id": carrier,
                        "package_id": $('#packageId').val(),
                    }
                    $.post(url, data, function (response) {
                        if (response) {
                            $('#courier_div').html(response)
                            $('select').niceSelect();
                            $('.preloader').addClass('d-none');

                        }
                    });
                });

                $(document).on('click', '.update_carrier_order', function (event) {
                    event.preventDefault();
                    $('.preloader').removeClass('d-none');
                    let id = $(this).data('id');
                    let url = $('#update_carrier_order_url').val();
                    url = url.replace(':id', id);
                    $.get(url, function (response) {
                        if (response) {
                            $('.preloader').addClass('d-none');
                            if (response.status == 'NEW') {
                                let url = "{{ url('shipping.edit_carrier_order',':id') }}";
                                url = url.replace(':id', id);
                                document.location.href = url;
                            } else {
                                toastr.warning('Order Update Not Possible')
                            }

                        }
                    });
                });

                $(document).on('change', '#set_pickup_location', function (event) {
                    event.preventDefault();
                    $('.preloader').removeClass('d-none');
                    let location = $('#set_pickup_location:checked').val();
                    let url = $('#set_pickup_location_url').val();
                    url = url.replace(':location', location);
                    $.get(url, function (response) {
                        if (response) {
                            $('.preloader').addClass('d-none');
                            toastr.success('Pickup Location Change Successfully.')
                        }
                    });
                });

                $(document).on('change', '#filter', function (event) {
                    let filter = $(this).val();
                    let couriers = JSON.parse($('#couriers_data').val());

                    if (filter == "1") {
                        couriers.sort(function (a, b) {
                            return a['freight_charge'] - b['freight_charge'];
                        });
                    } else {
                        couriers.sort(dynamicAlphabeticallySort("estimated_delivery_days"));
                    }
                    let data = ``;

                    $.each(couriers, function (index, c) {
                        data += ` <li>
                                    <label class="primary_checkbox d-flex mr-12 ">
                                        <input name="shipping_method" class="shipping_method" type="radio" id="shipping_method" value="` + c.courier_company_id + `">
                                        <span class="checkmark"></span>
                                    </label>
                                    <p>` + c.courier_name + ` (Freight Charges: ` + c.freight_charge + ` , {{__('product.estimated_delivery')}}: ` + c.estimated_delivery_days + ` days)</p>
                                 </li>
                                `
                    });
                    $('#courier_data').html(data);
                });


                var selector = ".date_range_input"
                $(selector).on('apply.daterangepicker', function (ev, picker) {
                    $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
                    // resetAfterChange();
                });

                $(selector).daterangepicker({
                    autoUpdateInput: false,
                    opens: rtl == "rtl" ? "left" : "right",

                    locale: {
                        cancelLabel: 'Clear'
                    },
                    ranges: {
                        'Today': [moment(), moment()],
                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                        'This Month': [moment().startOf('month'), moment().endOf('month')],
                        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                        'This Year': [moment().startOf('year'), moment().endOf('year')],
                        'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                    }


                }, function (start, end, label) {

                });


                /**
                 * Function to sort alphabetically an array of objects by some specific key.
                 *
                 * @param {String} property Key of the object to sort.
                 */
                function dynamicAlphabeticallySort(property) {
                    var sortOrder = 1;
                    if (property[0] === "-") {
                        sortOrder = -1;
                        property = property.substr(1);
                    }

                    return function (a, b) {
                        if (sortOrder == -1) {
                            return b[property].localeCompare(a[property]);
                        } else {
                            return a[property].localeCompare(b[property]);
                        }
                    }
                }
            });


            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5,]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
