<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Modules\SupportTicket\Entities\TicketPriority;

class CreateSupportTicketPiorityTable extends Migration
{
    public function up()
    {
        Schema::create('support_ticket_pirority', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });

        TicketPriority::create(['name' => 'High']);
        TicketPriority::create(['name' => 'Medium']);
        TicketPriority::create(['name' => 'Low']);
    }

    public function down()
    {
        Schema::dropIfExists('support_ticket_pirority');
    }
}
