<?php

namespace Modules\Survey\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Survey\Entities\Survey;
use Modules\Survey\Entities\SurveyAssign;
use Modules\Survey\Entities\SurveyAnswerSubmit;
use Modules\Survey\Entities\StudentGroup;

class StudentSurveyApiController extends Controller
{
    public function __construct()
    {
        config(['auth.defaults.guard' => 'api']);
    }

    public function studentSurvey()
    {
        try {

            $ids = SurveyAssign::where('user_id', Auth::id())
                ->pluck('survey_id')->toArray();
            $query = Survey::whereIn('id', $ids)->orWhere('survey_type', 2);


            if (isModuleActive('Org')) {
                $query->where(function ($q) {
                    $q->where('audience', 1)
                        ->orWhere(function ($q) {
                            $q->where('audience', 2);
                            if (Auth::check()) {
                                if (Auth::user()->role_id != 1) {
                                    $q->whereHas('branches', function ($q) {
                                        $q->whereIn('branch_id', getAllChildCodeIds(Auth::user()->branch, [Auth::user()->branch->id]));
                                    });
                                }
                            } else {
                                $q->whereHas('branches', function ($q) {
                                    $q->where('branch_id', 0);
                                });
                            }
                        });
                });

                $query->where(function ($q) {
                    $q->where('position_audience', 1)
                        ->orWhere(function ($q) {
                            $q->where('position_audience', 2);
                            if (Auth::check()) {
                                if (Auth::user()->role_id != 1) {
                                    $q->whereHas('positions', function ($q) {
                                        $q->whereIn('position_id', getAllChildCodeIds(Auth::user()->position, [Auth::user()->position->id]));
                                    });
                                }
                            } else {
                                $q->whereHas('positions', function ($q) {
                                    $q->where('position_id', 0);
                                });
                            }
                        });
                });
            }
            $surveys = $query->with('course')->get();

            foreach ($surveys as $survey) {
                $survey->course_title = $survey->course->title;
                $survey->participateStatus = $survey->loginUserParticipant();
            }

            $response = [
                'success' => true,
                'data' => $surveys,
                'message' => 'Getting Survey Data',
            ];
            return response()->json($response, 200);
        } catch (\Exception $e) {
            $response = [
                'success' => false,
                'message' => 'Operation failed',
                'error' => $e->getMessage(),
            ];
            return response()->json($response, 200);
        }
    }


    public function store(Request $request)
    {

        $ids = SurveyAssign::where('user_id', Auth::id())
            ->pluck('survey_id')->toArray();
        $survey = Survey::findOrFail($request->survey_id);
        if ($survey->survey_type != 2 && !in_array($request->survey_id, $ids)) {
            $response = [
                'success' => false,
                'message' => trans('survey.You Are not assigned for this survey'),
            ];
            return response()->json($response, 200);
        }
        try {
            if (!empty($request->question)) {
                foreach ($request->question as $key => $question) {
                    if (isset($request->survey_answer[$question])) {
                        if (gettype($request->survey_answer[$question]) == "array") {
                            SurveyAnswerSubmit::where('question_id', $question)->delete();
                            foreach ($request->survey_answer[$question] as $ans) {
                                SurveyAnswerSubmit::create([
                                    'survey_id' => $survey->id,
                                    'user_id' => Auth::id(),
                                    'question_id' => $question,
                                    'assign_id' => 0,
                                    'answer' => $ans,
                                ]);
                            }
                        } else {
                            SurveyAnswerSubmit::updateOrCreate([
                                'survey_id' => $survey->id,
                                'user_id' => Auth::id(),
                                'question_id' => $question,
                            ], [
                                'assign_id' => 0,
                                'answer' => $request->survey_answer[$question] ?? '',
                            ]);
                        }
                    }
                }
            }
            $response = [
                'success' => true,
                'message' => 'Operation successful',
            ];
            return response()->json($response, 200);
        } catch (\Exception $e) {
            $response = [
                'success' => false,
                'message' => 'Operation failed',
                'error' => $e->getMessage(),
            ];
            return response()->json($response, 200);
        }
    }


    public function show($id)
    {
        $survey = Survey::where('id', $id)->with('questionAssigns', 'questionAssigns.questionBank', 'questionAssigns.questionBank.questionMu')->firstOrFail();
        $submitted_answers = SurveyAnswerSubmit::where('user_id', Auth::id())->where('survey_id', $survey->id)->get();
        foreach ($survey->questionAssigns as $assign) {
            $question = $assign->questionBank;
            $submitted_answer = $submitted_answers->where('question_id', $question->id)->first();

            if ($question->type == 'checkbox') {
                foreach ($question->questionMu as $attribute) {
                    $attribute->checked = isset($submitted_answers) ? $submitted_answers->where('answer', $attribute->id)->first() ? true : false : false;
                    $attribute->title = $attribute->title;
                }
            } elseif ($question->type == 'dropdown') {
                foreach ($question->questionMu as $attribute) {
                    $attribute->checked = isset($submitted_answer) ? $submitted_answer->answer == $attribute->id ? true : false : false;
                }
            } elseif ($question->type == 'linear_scale') {

                $option = $question->number_of_option;
                $collection = collect();
                for ($i = 1; $i <= $option; $i++) {
                    $collection->push(['id' => $i, 'checked' => isset($submitted_answer) ? $submitted_answer->answer == $i ? true : false : false]);
                    $collection->toArray();

                    $question->options = $collection->toArray();
                }
            } elseif ($question->type == 'radio') {
                foreach ($question->questionMu as $attribute) {
                    $attribute->checked = isset($submitted_answer) ? $submitted_answer->answer == $attribute->id ? true : false : false;
                }
            } else {
                $question->answer = $submitted_answers->where('question_id', $question->id)->first() ? $submitted_answers->where('question_id', $question->id)->first()->answer : '';
            }

            if (!isset($submitted_answer)) {
                $assign->submitted = false;
            } else {
                $assign->submitted = true;
            }
        }


        $response = [
            'success' => true,
            'data' => $survey,
            'message' => 'Operation failed',
        ];
        return response()->json($response, 200);
    }
}
