@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box">
                        <div class="main-title">
                            <h3 class="mb-30">{{__('common.Select')}} {{__('survey.Criteria')}}</h3>
                        </div>
                        <form method="POST" action="{{ route('survey.question_based_graph_search', $survey->id) }}"
                              class="form-horizontal" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6 mt-30-md">
                                    <select
                                        class="niceSelect w-100 bb form-control {{ $errors->has('question_id') ? ' is-invalid' : '' }}"
                                        name="question_id">
                                        <option value="">{{__('common.Select')}} {{__('quiz.Question')}} </option>
                                        @foreach ($survey->questionAssigns as $assign)
                                            @php
                                                $question= $assign->questionBank;
                                                 if($question->type=='textarea'){
                                                     continue;
                                                 }
                                            @endphp
                                            <option
                                                {{isset($selected_question)? $selected_question->id==$question->id ? 'selected':'' :''}} value="{{$question->id}}">{!! $question->question !!}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('question_id'))
                                        <span class="invalid-feedback invalid-select" role="alert">
                            <strong>{{ $errors->first('question_id') }}</strong>
                        </span>
                                    @endif
                                </div>
                                <div class="col-lg-3 mt-30-md">
                                    <select
                                        class="niceSelect w-100 bb form-control {{ $errors->has('graph_type') ? ' is-invalid' : '' }}"
                                        name="graph_type">
                                        <option value="">{{__('common.Select')}} {{__('survey.Graph')}}</option>
                                        <option
                                            {{isset($graph_type)? $graph_type=='pie' ? 'selected':'' :''}} value="pie">{{__('survey.Pie')}}</option>
                                        <option
                                            {{isset($graph_type)? $graph_type=='bar' ? 'selected':'' :''}} value="bar">{{__('survey.Bar')}}</option>
                                        <option
                                            {{isset($graph_type)? $graph_type=='line' ? 'selected':'' :''}} value="line">{{__('survey.Line')}}</option>
                                    </select>
                                    @if ($errors->has('graph_type'))
                                        <span class="invalid-feedback invalid-select" role="alert">
                            <strong>{{ $errors->first('graph_type') }}</strong>
                        </span>
                                    @endif
                                </div>
                                <div class="col-lg-3 mt-30-md">
                                    <button type="submit" class="primary-btn small fix-gr-bg">
                                        <span class="ti-search pe-2"></span>
                                        {{__('common.Search')}}
                                    </button>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="row mt-20">
                <div class="col-lg-12">
                    <div class="white-box mb-30">

                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-flex flex-wrap mb-0">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('survey.Survey')}} {{__('survey.Participation')}} </h3>

                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-lg-12 text-center">
                                <h2>
                                    {{$survey->title}}
                                </h2>
                                {!! $survey->description !!}
                                @if (isset($selected_question))
                                    <h3 class="mt-5">{{__('quiz.Question')}}: {!! $selected_question->question !!}</h3>
                                @endif
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>
        @if (isset($selected_question))

            <h1>{{__('survey.Survey Report')}}</h1>



            <div class="white_box chart_box mt-20 d-flex justify-content-center">
                <div class="chartjs-size-monitor">
                    <div class="chartjs-size-monitor-expand">
                        <div class="">
                        </div>
                    </div>
                    <div class="chartjs-size-monitor-shrink">
                        <div class="">
                        </div>
                    </div>
                </div>
                <h4>{{@$selected_question->title}}</h4>
                <div class="">
                    <div class="chartjs-size-monitor">
                        <div class="chartjs-size-monitor-expand">
                            <div class=""></div>
                        </div>
                        <div class="chartjs-size-monitor-shrink">
                            <div class=""></div>
                        </div>
                    </div>
                </div>
                @if (@$graph_type=='line')
                    <div id="linechart" style="width: 900px; height: 500px"></div>

                @endif
                @if (@$graph_type=='pie')
                    <div id="piechart" style="width: 900px; height: 500px"></div>
                @endif
                @if (@$graph_type=='bar')
                    <div id="barchart" style="width: 900px; height: 500px; padding:5px"></div>
                @endif
            </div>
        @endif


    </section>

@endsection

@push('scripts')
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

    <script>
        (function ($) {
            "use strict";
            let answer_set = <?php echo @$answer_set; ?>;
            google.charts.load('current', {'packages': ['corechart']});
            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {

                let data = google.visualization.arrayToDataTable(answer_set);

                let options = {
                    title: '',
                    'backgroundColor': 'transparent',

                };

                let chart = new google.visualization.PieChart(document.getElementById('piechart'));

                chart.draw(data, options);


            }

            let barchart_answer_set = <?php echo @$answer_set; ?>;
            google.charts.load('current', {'packages': ['bar']});
            google.charts.setOnLoadCallback(drawStuff);

            function drawStuff() {
                let data = new google.visualization.arrayToDataTable(barchart_answer_set);

                let options = {
                    title: '',
                    'backgroundColor': 'transparent',
                    width: 1000,
                    legend: {position: 'none'},
                    chart: {
                        title: '',
                        subtitle: ''
                    },
                    bars: 'horizontal',
                    axes: {
                        x: {
                            0: {side: 'top', label: 'Percentage'} // Top x-axis.
                        }
                    },
                    bar: {groupWidth: "90%"}
                };

                let chart = new google.charts.Bar(document.getElementById('barchart'));
                chart.draw(data, options);
            }


            let linechart_answer_set = <?php echo @$answer_set; ?>;
            google.charts.load('current', {'packages': ['corechart']});
            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {
                let data = google.visualization.arrayToDataTable(linechart_answer_set);

                let options = {
                    title: '',
                    'backgroundColor': 'transparent',

                    curveType: 'function',
                    legend: {position: 'bottom'}
                };

                let chart = new google.visualization.LineChart(document.getElementById('linechart'));

                chart.draw(data, options);
            }

        })(jQuery);

    </script>
@endpush
