<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddTaxModulePermission extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => 'Tax', 'route' => 'tax', 'type' => 1, 'parent_route' => null, 'module' => 'Tax', 'ecommerce' => 1,],
            ['name' => 'Setting', 'route' => 'tax.setting.index', 'type' => 2, 'parent_route' => 'tax', 'module' => 'Tax', 'ecommerce' => 1,],
            ['name' => 'Country Wish Tax', 'route' => 'tax.country-wish-tax.index', 'type' => 2, 'parent_route' => 'tax', 'module' => 'Tax', 'ecommerce' => 1,],
        ];

        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }

    }

    public function down()
    {
        //
    }
}
