@if(isset($editInstructor))
    @foreach ($editInstructor->educations as $key => $education)
        <div class="row">
            <div class="col-xl-2">
                <div class="primary_input mb-25">
                    <label class="primary_input_label" for="">
                        {{ __('appointment.Duration (Years)') }}</label>
                    <input class="primary_input_field" name="education[{{ $key+100 }}][duration]"
                           placeholder="2012 — 2016" id="addDuration" type="text"
                           value="{{ $education->duration }}">
                </div>
            </div>
            <div class="col-xl-4">
                <div class="primary_input mb-25">
                    <label class="primary_input_label" for="">
                        {{ __('appointment.Degree') }}</label>
                    <input class="primary_input_field" name="education[{{ $key+100 }}][degree]"
                           placeholder="B.S. Animal Science and Industry" id="addDegree" type="text"
                           value="{{ $education->degree }}">
                </div>
            </div>

            <div class="col-xl-4">
                <div class="primary_input mb-25">
                    <label class="primary_input_label" for="">
                        {{ __('appointment.Institute') }}</label>
                    <input class="primary_input_field" name="education[{{ $key+100 }}][institute]"
                           placeholder="Kansas State University" id="addInstitute" type="text"
                           value="{{ $education->institute }}">
                </div>
            </div>
            @if (auth()->user()->role_id == 1)
                <div class="col-xl-1 mt-33">
                    <label class="primary_checkbox d-flex mr-12">
                        <input type="checkbox" id="verified" name="education[{{ $key+100 }}][is_verified]"
                            {{ isset($editInstructor) ? ($education->is_verified == 1 ? 'checked' : '') : '' }}>
                        <span class="checkmark me-2"></span>{{ __('appointment.Verified') }}
                    </label>
                </div>
            @endif

            <div class="col-xl-1 mt-33">
                <button class="removeEducationBtn primary-btn icon-only fix-gr-bg fl-r"
                        type="button">
                    <span class="ti-trash"></span></button>
            </div>
        </div>
    @endforeach
    @if (count($editInstructor->educations)==0 || empty($editInstructor->educations))
        @includeIf('appointment::instructor.inc.create_education')
    @endif
@endif
