<table class="display school-table school-table-style p-0 shadow-none" cellspacing="0" width="100%">
    <thead>
    <tr>
        <th>{{ __('appointment.Time Slot') }}</th>
        @foreach ($periods as $key => $date)
            <th>{{ $date->format('d-M-y') }} <br>

                {{ $date->format('l') }}
            </th>
        @endforeach
    </tr>
    </thead>

    <tbody>
    @foreach ($timeSlots as $slot)
        <tr>
            <td>{{ date('h:i A', strtotime(@$slot->start_time)) }} -
                {{ date('h:i A', strtotime(@$slot->end_time)) }}</td>
            @foreach ($periods as $key => $date)
                <td>
                    @php
                        $teachingInfo = Modules\Appointment\Entities\Schedule::teachingInfo($slot->id, $date->format('Y-m-d'), $user_id);
                    @endphp
                    @if ($teachingInfo)
                        {{ $teachingInfo->category->name }} <br>
                        {{ $teachingInfo->sub_category ? '(' . $teachingInfo->subCategory->name . ')' : '' }}

                        <label class="switch_toggle"
                        >
                            <input type="checkbox" class="schedule_status_enable_disable"
                                   @if (@$teachingInfo->status == 1) checked @endif
                                   value="{{ @$teachingInfo->id }}">
                            <i class="slider round"></i>
                        </label>
                        @if(count($teachingInfo->activeBooked) > 0)
                            <p>{{ __('appointment.Total Booked') }} :
                                <a href="{{ route('appointment.booking.user',['date'=>$date->format('Y-m-d'), 'time_slot' => $slot->id, 'instructor_id'=>$user_id]) }}"
                                   target="_blank"> <strong>({{ count($teachingInfo->activeBooked) }})</strong></a>
                            </p>
                        @endif


                        <div class="d-flex">
                            @if (permissionCheck('appointment.schedule.edit'))
                                <a data-bs-toggle="modal" id="edit_schedule_modal_btn"
                                   data-bs-target="#edit_schedule_modal_{{ $teachingInfo->id }}"
                                   href="#" data-schedule_id="{{ $teachingInfo->id }}"
                                   class="primary-btn small icon-only edit_schedule_modal"
                                   data-modal-size="modal-md"
                                   title="{{ __('appointment.Update Schedule') }}">
                                    <span class="ti-pencil" id=""></span>
                                </a>
                            @endif
                            @if (permissionCheck('appointment.schedule.destroy'))
                                <a onclick="confirm_modal('{{ route('appointment.schedule.destroy', @$teachingInfo->id) }}');"
                                   class="primary-btn small icon-only" data-modal-size="modal-md"
                                   title="">
                                    <span class="ti-trash" id=""></span>
                                </a>
                            @endif
                        </div>
                        @includeIf('appointment::schedule.inc._edit_schedule_modal')
                    @else
                        @if (permissionCheck('appointment.schedule.store'))
                            <a data-bs-toggle="modal" id="add_schedule_btn" data-bs-target="#add_schedule"
                               href="#" class="primary-btn small icon-only   add_schedule_btn"
                               data-slot_id="{{ $slot->id }}"
                               data-start_date="{{ $date->format('m/d/Y') }}"
                               data-modal-size="modal-md"
                               title="{{ __('appointment.Add New Schedule') }}">
                                <span class="ti-plus" id=""></span>
                            </a>
                        @endif
                    @endif

                </td>
            @endforeach
        </tr>
    @endforeach
    </tbody>
</table>
