<?php

namespace Modules\Assignment\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;

class InfixSubmitAssignment extends Model
{
    use Tenantable;

    protected $fillable = [];


    public function student()
    {
        return $this->belongsTo(User::class, 'student_id', 'id')->withDefault();
    }

    public function assigned()
    {
        return $this->belongsTo(InfixAssignAssignment::class, 'assign_id', 'id')->withDefault();
    }

    static function assignmentLastSubmitted($assignment_id, $student_id)
    {
        $submitted_answer = InfixSubmitAssignment::where('assignment_id', $assignment_id)->where('student_id', $student_id)->orderBy('id', 'desc')->first();
        if ($submitted_answer) {
            return $submitted_answer;
        } else {
            return null;
        }
    }
}
