<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIsInstallmentColumnToCartsTable extends Migration
{
    public function up()
    {
        Schema::table('carts', function (Blueprint $table) {
            if (!Schema::hasColumn('carts', 'is_installment')) {
                $table->boolean('is_installment')->default(0)->comment('0=No,1=Yes');
            }
            if (!Schema::hasColumn('carts', 'plan_id')) {
                $table->bigInteger('plan_id')->nullable()->comment('installment_plan_id');
            }
            if (!Schema::hasColumn('carts', 'installment_type')) {
                $table->string('installment_type')->nullable()->comment('installment_plan_id');
            }
            if (!Schema::hasColumn('carts', 'purchase_id')) {
                $table->bigInteger('purchase_id')->nullable()->comment('installment_purchase_id');
            }
        });

        Schema::table('course_enrolleds', function (Blueprint $table) {
            if (!Schema::hasColumn('course_enrolleds', 'installment_purchase_id')) {
                $table->bigInteger('installment_purchase_id')->nullable()->comment('installment_purchase_id');
            }
        });

        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'installment_verified')) {
                $table->boolean('installment_verified')->default(0)->comment('0=No,1=Yes');
            }
            if (!Schema::hasColumn('users', 'installment_eligibility')) {
                $table->boolean('installment_eligibility')->default(1)->comment('0=No,1=Yes');
            }
            if (!Schema::hasColumn('users', 'installment_due_course')) {
                $table->json('installment_due_course')->nullable()->comment('installment_due_course');
            }
        });
    }


    public function down()
    {
    }
}
