@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="main-title d-md-flex mb-20">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ $data['title'] }}</h3>


                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            @foreach ($data['table_columns'] as $th)
                                                <th scope="col">{{ $th }}</th>
                                            @endforeach
                                        </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection
@push('scripts')

    @if ($errors->any())
        <script>
            (function ($) {
                "use strict";

                @if(Session::has('type'))
                @if(Session::get('type')=="store")
                $('#add_student').modal('show');
                @else
                $('#editStudent').modal('show');
                @endif
                @endif

            })(jQuery);

        </script>
    @endif


    @php
        $url = route('installment.purchase.list_ajax');
    @endphp

    <script>
        (function ($) {
            "use strict";

            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id', orderable: true},
                {data: 'name', name: 'name'},
                {data: 'plan', name: 'plan.title'},
                {data: 'topic', name: 'topic.title'},
                {data: 'purchase_date', name: 'purchase_date'},
                {data: 'total_amount', name: 'total_amount'},
                {data: 'upfront', name: 'upfront', searchable: false},
                {data: 'installment', name: 'installment', searchable: false},
                {data: 'overdue', name: 'overdue', searchable: false},
                {data: 'overdue_amount', name: 'overdue_amount', searchable: false},
                {data: 'remaining_days', name: 'remaining_days', searchable: false},
                {data: 'status', name: 'status', searchable: false},
                {data: 'action', name: 'action', searchable: false, orderable: false},
            ]
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);
    </script>

    <script src="{{asset('public/backend/js/student_list.js')}}"></script>

@endpush
