<?php

namespace Modules\Noticeboard\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class NoticeTypeRequest extends FormRequest
{
    public function rules()
    {
        $route = Request::route()->getName();
        $rules = [];
        if ($route == 'noticeboard.type.store' || $route == 'noticeboard.type.update') {
            $rules['title'] = 'required';
            $rules['color'] = 'required';
        }

        if ($route == 'noticeboard.type.update' || $route == 'noticeboard.type.delete') {
            $rules['id'] = 'required';
        }
        return $rules;
    }

    public function authorize()
    {
        return true;
    }

    public function messages(): array
    {
        return validationMessage($this->rules());
    }
}
