<?php

namespace Modules\Store\Http\Controllers;

use App\Traits\UploadMedia;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Store\Entities\ProductBrand;
use Modules\Store\Http\Requests\BrandRequest;
use Modules\Store\Repositories\ProductBrandRepository;

class BrandController extends Controller
{

    use ValidatesRequests, UploadMedia;

    public $ProductBrandRepository;

    public function __construct(ProductBrandRepository $ProductBrandRepository)
    {
        $this->ProductBrandRepository = $ProductBrandRepository;
    }

    public function index()
    {
        try {

            $brands = ProductBrand::orderBy('id', 'desc')->get();
            return view('store::brands.index', compact('brands'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function create()
    {
        try {

            return view('store::brands.create');
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function store(BrandRequest $request)
    {
        try {
            $author = $this->ProductBrandRepository->create($request);
            if ($author) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.brand.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function edit($id)
    {
        try {
            $edit = ProductBrand::find($id);

            return view('store::brands.create', compact('edit'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function update(Request $request)
    {
        try {
            $author = $this->ProductBrandRepository->update($request);

            if ($author) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.brand.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function destroy($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {

            $author = $this->ProductBrandRepository->delete($id);
            if ($author) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
