@extends('backend.master')
@push('styles')
 @endpush
@php
    $table_name='plan_features';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-3">
                    <div class="common_table_header">
                        <div class="main-title d-flex flex-wrap mb-0">

                            @if(isset($edit))
                                <a href="{{route('subscription.planFeature.index')}}"
                                   class="primary-btn small fix-gr-bg ms-4" style="line-height: 25px;"
                                   title="{{__('courses.Add New')}}">+</a>
                            @endif
                        </div>
                    </div>
                    <div class="white-box mb_30  student-details header-menu">
                        <div class="col-12">
                            <div class="box_header common_table_header">
                                <div class="main-title d-md-flex">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('subscription.Plan Feature Add')}}</h3>


                                </div>
                            </div>
                        </div>

                        @if (isset($edit))
                            <form action="{{route('subscription.planFeature.update')}}" method="POST"
                                  id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                <input type="hidden" name="id"
                                       value="{{$edit->id}}">
                                @else

                                    <form action="{{route('subscription.planFeature.store') }}" method="POST"
                                          id="category-form" name="category-form"
                                          enctype="multipart/form-data">
                                        @endif

                                        @csrf

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="descriptionInput">{{ __('common.Title') }} <strong
                                                            class="text-danger">*</strong> </label>
                                                    <input name="title"
                                                           class="primary_input_field title {{ @$errors->has('title') ? ' is-invalid' : '' }}"
                                                           placeholder="{{ __('common.Title') }}"
                                                           type="text"
                                                           value="{{isset($edit)?$edit->title:old('title')}}" {{$errors->has('title') ? 'autofocus' : ''}}>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <input type="hidden" name="plan" value="{{$id}}">

                                            <div class="col-lg-12 text-center">
                                                <div class="d-flex justify-content-center pt_20">
                                                    <button type="submit"
                                                            class="primary-btn semi_large fix-gr-bg"
                                                            data-bs-toggle="tooltip"
                                                            id="save_button_parent">
                                                        <i class=" fa fa-check "></i>
                                                        @if(!isset($edit))
                                                            {{ __('common.Save') }}
                                                        @else
                                                            {{ __('common.Update') }}
                                                        @endif
                                                    </button>


                                                </div>
                                            </div>
                                        </div>

                                    </form>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="white-box">
                        <div class="col-12">
                            <div class="box_header common_table_header">
                                <div class="main-title d-md-flex">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('subscription.Plan Feature List')}}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">

                                <div class="">
                                    <table id="" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            @if($hasPlan)
                                                <th scope="col">{{__('subscription.Plan')}}</th>
                                            @endif
                                            <th scope="col">{{__('subscription.Title')}}</th>
                                            <th></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($features as $key => $feature)
                                            <tr data-id="{{$feature->id}}">

                                                <td>
                                                    <i class="ti-menu"></i>
                                                </td>
                                                @if($hasPlan)
                                                    <td>{{@$feature->plan->title}}</td>
                                                @endif
                                                <td>{{@$feature->title}}</td>


                                                <td>
                                                    <button
                                                        class="deleteplan primary-btn radius_30px fix-gr-bg float-end"
                                                        data-id="{{$feature->id}}"
                                                        type="button">{{__('common.Delete')}}</button>
                                                </td>
                                            </tr>

                                        @endforeach
                                        @if(count($features)==0)
                                            <tr>
                                                <td colspan="4" class="text-center">
                                                    {{__('common.No data available in the table')}}
                                                </td>
                                            </tr>
                                        @endif
                                        </tbody>

                                        <tfoot>

                                        </tfoot>
                                    </table>
                                    <section class=" white-box" id="AddFeatureSection" style="display:none;">
                                        <form action="{{route('subscription.planFeature.store')}}" method="POST"
                                              enctype="multipart/form-data">
                                            @csrf
                                            <div id="result">
                                                <div class="row">
                                                    <div class="col-md-8">
                                                        <div class="form-group">
                                                            <input placeholder="Enter Feature Title"
                                                                   class="primary_input_field"
                                                                   name="title" required type="text">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <button class="primary-btn radius_30px mr-10 mt-10 fix-gr-bg"
                                                                type="submit">{{__('common.Save')}}</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>

                                    </section>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade admin-query" id="add_plan">
                    <div class="modal-dialog modal_1000px modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">{{__('subscription.Add Plan Feature')}}</h4>
                                <button type="button" class="close " data-bs-dismiss="modal">
                                    <i class="ti-close "></i>
                                </button>
                            </div>

                            <div class="modal-body">
                                <form action="{{route('subscription.planFeature.store')}}" method="POST"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for="">{{__('subscription.Title')}} <strong
                                                        class="text-danger">*</strong></label>
                                                <input class="primary_input_field" name="title" placeholder="-"
                                                       required
                                                       type="text" id="addTitle"
                                                       value="{{ old('title') }}" {{$errors->first('title') ? 'autofocus' : ''}}>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-lg-12 text-center pt_15">
                                        <div class="d-flex justify-content-center">
                                            <button class="primary-btn semi_large2  fix-gr-bg" id="save_button_parent"
                                                    type="submit"><i
                                                    class="ti-check"></i> {{__('common.Save')}} {{__('subscription.Plan Feature')}}
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="modal fade admin-query" id="editplan">
                    <div class="modal-dialog modal_1000px modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">{{__('subscription.Update Plan Feature')}}</h4>
                                <button type="button" class="close " data-bs-dismiss="modal">
                                    <i class="ti-close "></i>
                                </button>
                            </div>

                            <div class="modal-body">
                                <form action="{{route('subscription.planFeature.update')}}" method="POST"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="id" value="{{old('id')}}" id="planId">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for="">{{__('subscription.Title')}} <strong
                                                        class="text-danger">*</strong></label>
                                                <input class="primary_input_field" name="title" placeholder="-"
                                                       required
                                                       type="text" id="editTitle"
                                                       value="{{ old('title') }}" {{$errors->first('title') ? 'autofocus' : ''}}>
                                            </div>
                                        </div>


                                    </div>

                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for="">{{__('subscription.Order')}} <strong
                                                        class="text-danger">*</strong></label>
                                                <input class="primary_input_field" name="order" placeholder="-"
                                                       required
                                                       type="text" id="editOrder"
                                                       value="{{ old('order') }}" {{$errors->first('order') ? 'autofocus' : ''}}>
                                            </div>
                                        </div>


                                    </div>
                                    <div class="col-lg-12 text-center pt_15">
                                        <div class="d-flex justify-content-center">
                                            <button class="primary-btn semi_large2  fix-gr-bg"
                                                    id="save_button_parent" type="submit"><i
                                                    class="ti-check"></i> {{__('subscription.Update Plan Feature')}}
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade admin-query" id="deleteplan">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">{{__('common.Delete')}} {{__('subscription.Plan Feature')}} </h4>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                        class="ti-close "></i></button>
                            </div>

                            <div class="modal-body">
                                <form action="{{route('subscription.planFeature.destroy')}}" method="post">
                                    @csrf

                                    <div class="text-center">

                                        <h4>{{__('common.Are you sure to delete ?')}} </h4>
                                    </div>
                                    <input type="hidden" name="id" value="" id="planDeleteId">
                                    <div class="mt-40 d-flex justify-content-between">
                                        <button type="button" class="primary-btn tr-bg"
                                                data-bs-dismiss="modal">{{__('common.Cancel')}}</button>

                                        <button class="primary-btn fix-gr-bg"
                                                type="submit">{{__('common.Delete')}}</button>

                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

@endsection
@push('scripts')
    @include('subscription::feature.script')
@endpush

