<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWhatsappSupportAgentsTable extends Migration
{

    public function up()
    {
        Schema::create('whatsapp_support_agents', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('designation')->nullable();
            $table->string('avatar')->nullable();
            $table->string('number')->nullable();
            $table->boolean('status')->default(true);
            $table->boolean('always_available')->default(false);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('whatsapp_support_agents');
    }
}
