<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class AddBundleIdInAffiliateReferrralPayment extends Migration
{
    public function up()
    {
        Schema::table('affiliate_referral_payments', function ($table) {
            if (!Schema::hasColumn('affiliate_referral_payments', 'type')) {
                $table->string('type')->default('course')->nullable();
            }
            if (!Schema::hasColumn('affiliate_referral_payments', 'bundle_id')) {
                $table->integer('bundle_id')->nullable();
            }
        });

        $routes = [
            ['name' => 'Commission Settings', 'route' => 'affiliate.commission.settings', 'parent_route' => 'affiliate', 'type' => 2, 'backend' => 1, 'module' => 'Affiliate'],


        ];
        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {
        //
    }
}
