<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstructorReviewsTable extends Migration
{
    public function up()
    {
        Schema::create('instructor_reviews', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('instructor_id')->nullable();
            $table->foreign('instructor_id')->on('users')->references('id')->cascadeOnDelete();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->on('users')->references('id')->nullOnDelete();

            $table->boolean('status')->nullable()->default(1);
            $table->text('comment')->nullable();
            $table->float('star')->nullable()->default(5);
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('instructor_reviews');
    }
}
