<?php

namespace Modules\Appointment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;
use Modules\Appointment\Http\Requests\Frontend\InstructorReviewRequest;
use Modules\Appointment\Repositories\Interfaces\ReviewRepositoryInterface;

class ReviewController extends Controller
{
    public $reviewRepository;

    public function __construct(
        ReviewRepositoryInterface $reviewRepository
    )
    {
        $this->reviewRepository = $reviewRepository;
    }

    public function index()
    {
        $data['reviews'] = $this->reviewRepository->index();
        return view('appointment::index');
    }


    public function create()
    {

        return view('appointment::create');
    }

    public function store(Request $request)
    {
        $this->reviewRepository->create($request->except('_token'));
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }




}
