<?php

namespace Modules\Appointment\Repositories\Eloquents;

use App\User;
use Modules\Localization\Entities\Language;
use Modules\CourseSetting\Entities\Category;
use App\Repositories\Eloquents\BaseRepository;
use Modules\Appointment\Entities\InstructorTeachingCategory;
use Modules\CourseSetting\Entities\CourseLevel;
use Modules\Appointment\Repositories\Interfaces\InstructorRepositoryInterface;

class InstructorRepository extends BaseRepository implements InstructorRepositoryInterface
{
    protected $level;
    protected $category;
    protected $language;
    protected $instructorTeachingCategory;

    public function __construct(
        User                       $model,
        CourseLevel                $level,
        Category                   $category,
        Language                   $language,
        InstructorTeachingCategory $instructorTeachingCategory
    )
    {
        $this->level = $level;
        $this->language = $language;
        $this->category = $category;
        parent::__construct($model);
        $this->instructorTeachingCategory = $instructorTeachingCategory;
    }

    public function getIndex(): array
    {
        $data = [];
        $teachingCategoryIds = $this->instructorTeachingCategory
            ->where('instructor_id', auth()->user()->id)
            ->pluck('id')->toArray();
        $data['levels'] = $this->level->get(['id', 'title']);
        $data['categories'] = $this->category
            ->when($teachingCategoryIds, function ($query) use ($teachingCategoryIds) {
                $query->whereIn('id', $teachingCategoryIds);
            })->get(['id', 'name']);

        $data['languages'] = $this->language->get(['id', 'name']);
        return $data;
    }

    public function editData($modelId): array
    {
        $data = $this->getIndex();
        $data['editInstructor'] = $this->findById($modelId);
        return $data;
    }

    public function instructors(): array
    {
        $data = [];
        $data['instructors'] = $this->model->where('role_id', 2)
            ->where('is_available', 1)
            ->where('lms_id', auth()->user()->lms_id)
            ->get(['id', 'name']);
        return $data;
    }

    public function instructorBySlug($slug): array
    {

        $data['instructor'] = $this->model->where('id', $slug)->first();
        if (!$data['instructor']) {
            $data['instructor'] = $this->model->where('slug', $slug)->first();
        }
        return $data;
    }

    public function instructorById($id): array
    {
        $data['instructor'] = $this->model->where('id', $id)->first();
        return $data;
    }
}
