<?php

namespace Modules\Gift\Console;

use App\Jobs\SendGeneralEmail;
use App\Jobs\SendNotification;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Modules\Gift\Entities\GiftRecord;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;

class SendGift extends Command
{
    protected $signature = 'send:gift';


    protected $description = 'Send gift to user';


    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {

        $gifts = GiftRecord::where('gift_send_time', '<=', now())
            ->get();
        foreach ($gifts as $gift_record) {
            if ($gift_record->gift_status == 1) {
                $created_time = $gift_record->created_at;
                $now = now();
                $diff = $created_time->diffInDays($now);
                if ($diff >= 30) {
                    $gift_record->gift_status = 5;
                    $gift_record->save();
                }

            }

            if ($gift_record->gift_status == 2) {
                $user = [];
                $user['email'] = $gift_record->gift_user_email;
                $user['name'] = $gift_record->gift_receiver_name;
                $course = $gift_record->course;
                $user = (object)$user;
                $gift_record_id_encrypt = encrypt($gift_record->id);

                $gift_record->gift_status = 3;
                $gift_record->save();

                SendNotification::dispatch('SEND_GIFT', $user,  [
                    'sender' => $gift_record->sender->name,
                    'course' => $course->title,
                    'name' => $user->name,
                    'message' => $gift_record->gift_message,
                    'course_link' => route('gift.link', $gift_record_id_encrypt),
                ],[]);

            }


            if ($gift_record->gift_status == 5) {
                $gift_record->delete();
            }
        }
    }

    protected function getArguments()
    {
        return [
            ['example', InputArgument::REQUIRED, 'An example argument.'],
        ];
    }

    protected function getOptions()
    {
        return [
            ['example', null, InputOption::VALUE_OPTIONAL, 'An example option.', null],
        ];
    }
}
