<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIsGiftColumnToCartTable extends Migration
{
    public function up()
    {
        if (Schema::hastable('carts')) {
            if (!Schema::hasColumn('carts', 'is_gift')) {
                Schema::table('carts', function (Blueprint $table) {
                    $table->boolean('is_gift')->default(0);
                });
            }
            if (!Schema::hasColumn('carts', 'gift_id')) {
                Schema::table('carts', function (Blueprint $table) {
                    $table->integer('gift_id')->nullable();
                });
            }

        }
    }

    public function down()
    {
        //
    }
}
