@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('public/backend/css/student_list.css')}}"/>
@endpush
@php
    $table_name='users';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{@$data['title']}}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{__('common.SL')}}</th>
                                            <th scope="col">{{__('common.Name')}}</th>
                                            <th scope="col">{{_trans('installment.Plan')}}</th>
                                            <th scope="col">{{_trans('installment.Product')}}</th>
                                            <th scope="col">{{_trans('installment.Amount')}}</th>
                                            <th scope="col">{{_trans('installment.Dur Date')}}</th>
                                            <th scope="col">{{_trans('installment.Status')}}</th>
                                            <th scope="col">{{_trans('installment.Payment Date')}}</th>
                                            <th scope="col">{{_trans('installment.Delay (Days)')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

@endsection
@push('scripts')

    @if ($errors->any())
        <script>
            (function ($) {
                "use strict";
                @if(Session::has('type'))
                @if(Session::get('type')=="store")
                $('#add_student').modal('show');
                @else
                $('#editStudent').modal('show');
                @endif
                @endif
            })(jQuery);

        </script>
    @endif


    @php
        $url = route('installment.overdue_history_ajax');
    @endphp

    <script>
        (function ($) {
            "use strict";

            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id', orderable: true},
                {data: 'name', name: 'name'},
                {data: 'plan', name: 'plan'},
                {data: 'product', name: 'product'},
                {data: 'amount', name: 'amount'},
                {data: 'due_date', name: 'due_date'},
                {data: 'status', name: 'status'},
                {data: 'payment_date', name: 'payment_date'},
                {data: 'delay', name: 'delay'},
                {data: 'action', name: 'action', orderable: false},
            ]
            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>

    <script src="{{asset('public/backend/js/student_list.js')}}"></script>

@endpush
