@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white_box mb_20">
                        <div class="white_box_tittle list_header main-title mb-0">
                            <h3 class="mb-20">{{ _trans('common.Advanced Filter') }}</h3>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <label class='primary_input_label'> {{ _trans('common.Bonus For') }} </label>
                                <select class='primary_select' id='bonus_for'>
                                    <option value="">{{ _trans('common.Please Select') }}</option>
                                    <option value="course_purchase">{{_trans('common.Course Purchase')}}</option>
                                    <option value="referr_users">{{ _trans('common.Referrer Users') }}</option>
                                    <option value="new_registration">{{ _trans('common.New Registration') }}</option>

                                </select>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <label class='primary_input_label'> {{ _trans("common.Start Date") }} </label>
                                <input type="text" placeholder="dd/mm/YYYY" name="start_date"
                                       class="primary_input_field date" id="start_date">
                            </div>

                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <label class='primary_input_label'> {{ _trans("common.End Date") }} </label>
                                <input type="text" placeholder="dd/mm/YYYY" name="start_date"
                                       class="primary_input_field date" id="end_date">
                            </div>

                            <div class="col-lg-12">
                                <button class="primary-btn   mr-10 mt-3 fix-gr-bg filter">
                                    <i class="ti-search"></i>
                                    {{ _trans("common.Filter") }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="white-box">
                <div class="row">
                    <h1 class="d-none" id="page_title">{{trans('coupons.Bonus History')}}</h1>
                    <div class="col-lg-12">
                        <h1 class="d-none" id="page_title"></h1>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table data-url='{{ route('registraion_bonus.dataTable') }}' id="lms_table"
                                           class="table classList dataTable no-footer dtr-inline collapsed">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ _trans('common.SL') }}</th>
                                            <th scope="col">{{ _trans('common.Name') }}</th>
                                            <th scope="col">{{ _trans('common.Role') }}</th>
                                            <th scope="col">{{ _trans('common.Bonus Type') }}</th>
                                            <th scope="col">{{ _trans('common.Amount') }}</th>
                                            <th scope="col">{{ _trans('common.Date') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js')
    <script>


        (function ($) {
            "use strict";

            $(document).ready(function () {

                $('.date').datepicker();

                dataTableOptions.serverSide = true
                dataTableOptions.processing = true
                dataTableOptions.ajax = {
                    url: $('#lms_table').attr('data-url'),
                    data: function (d) {
                        d.bonus_for = $("#bonus_for").val(),
                            d.start_date = $("#start_date").val(),
                            d.end_date = $("#end_date").val()
                    }
                };
                dataTableOptions.columns = [
                    {data: 'DT_RowIndex', name: 'id', orderable: true},
                    {data: 'user_name', name: 'user.name', orderable: true},  // User name
                    {data: 'role_name', name: 'user.role.name', orderable: true},  // User role
                    {data: 'bonus_for', name: 'bonus_for', orderable: true},
                    {data: 'amount', name: 'amount', orderable: true},
                    {data: 'created_at', name: 'created_at', orderable: true},
                ]
                dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5]);

                let table = $('#lms_table').DataTable(dataTableOptions);

                $('.dataTables_length label select').niceSelect();
                $('.dataTables_length label .nice-select').addClass('dataTable_select');


                function resetAfterChange() {
                    table.ajax.reload();
                }

                $(document).on('click', '.filter', function () {
                    resetAfterChange();
                });


            });

        })(jQuery);


    </script>
@endpush
