<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PickupLocationRequest extends FormRequest
{
    public function rules()
    {
        return [
            'pickup_location' => 'required',
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'address_2' => 'nullable',
            'city_id' => 'nullable',
            'state_id' => 'required',
            'country_id' => 'required',
            'pin_code' => 'required',
            'status' => 'nullable',
            'created_by' => 'nullable',
        ];
    }

    public function authorize()
    {
        return true;
    }
}
