<?php

namespace Modules\Store\Repositories;

use App\Traits\UploadMedia;
use Illuminate\Support\Str;
use Modules\Store\Entities\ProductCarrier;


class CarrierRepository
{
    use UploadMedia;

    public function all()
    {
        $seller_id = getParentSellerId();
        $a_carriers = ProductCarrier::where('type', 'Automatic');
        $m_carriers = ProductCarrier::where('type', 'Manual')->where('created_by', $seller_id);
        $carriers = $a_carriers->unionAll($m_carriers)->get();
        return $carriers;
    }

    public function getActiveAll()
    {
        $seller_id = getParentSellerId();
        $a_carriers = ProductCarrier::where('type', 'Automatic')->whereHas('carrierConfig', function ($q) use ($seller_id) {
            $q->where('seller_id', $seller_id)->where('carrier_status', 1);
        });
        $m_carriers = ProductCarrier::where('type', 'Manual')->where('created_by', $seller_id);
        $carriers = $a_carriers->unionAll($m_carriers)->where('status', 1)->get();


        return $carriers;
    }

    public function find($id)
    {
        return ProductCarrier::findOrfail($id);
    }


    public function overWriteEnvFile($type, $val)
    {
        $path = base_path('.env');
        if (file_exists($path)) {
            $val = '"' . trim($val) . '"';
            if (is_numeric(strpos(file_get_contents($path), $type)) && strpos(file_get_contents($path), $type) >= 0) {
                file_put_contents($path, str_replace(
                    $type . '="' . env($type) . '"', $type . '=' . $val, file_get_contents($path)
                ));
            } else {
                file_put_contents($path, file_get_contents($path) . "\r\n" . $type . '=' . $val);
            }
        }
    }

    public function create($data)
    {


        try {
            $seller_id = getParentSellerId();

            $carrier = new ProductCarrier();
            $carrier->name = $data['name'];
            $carrier->slug = Str::slug($data['name']);
            $carrier->tracking_url = $data['tracking_url'];
            $carrier->status = $data['status'] ?? 0;
            $carrier->created_by = $seller_id;
            $carrier->save();

            if (isset($data['logo'])) {
                $carrier->logo = $this->generateLink($data['logo'], $carrier->id, get_class($carrier), 'logo');
            }
            $carrier->save();
            return true;
        } catch (\Throwable $th) {
            return false;
        }

    }


    public function update($data)
    {
        try {
            $seller_id = getParentSellerId();

            $carrier = ProductCarrier::find($data['id']);
            $carrier->name = $data['name'];
            $carrier->slug = Str::slug($data['name']);
            $carrier->tracking_url = $data['tracking_url'];
            $carrier->status = $data['status'];
            $carrier->created_by = $seller_id;

            $carrier->logo = null;
            $carrier->save();

            if (isset($data['logo'])) {
                $carrier->logo = $this->generateLink($data['logo'], $carrier->id, get_class($carrier), 'logo');
            }
            $carrier->save();
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    public function delete($id)
    {
        $row = $this->find($id);
        if ($row->logo) {
            $this->deleteImage($row->logo);
        }
        return $row->delete();
    }


}
