<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUpcomingCoursesColumnToCoursesTable extends Migration
{
    public function up()
    {
        Schema::table('courses', function (Blueprint $table) {
            if (!Schema::hasColumn("courses", 'is_upcoming_course')) {
                $table->boolean('is_upcoming_course')->default(0);
            }
            if (!Schema::hasColumn("courses", 'publish_date')) {
                $table->date('publish_date')->nullable();
            }
            if (!Schema::hasColumn("courses", 'publish_status')) {
                $table->string('publish_status')->nullable();
            }
            if (!Schema::hasColumn("courses", 'is_allow_prebooking')) {
                $table->boolean('is_allow_prebooking')->default(0);
            }
            if (!Schema::hasColumn("courses", 'booking_amount')) {
                $table->double('booking_amount')->default(0);
            }
        });
    }

    public function down()
    {
        Schema::table('courses', function (Blueprint $table) {
            if (Schema::hasColumn("courses", 'is_upcoming_course')) {
                $table->dropColumn('is_upcoming_course');
            }
            if (Schema::hasColumn("courses", 'publish_date')) {
                $table->dropColumn('publish_date');
            }
            if (Schema::hasColumn("courses", 'publish_status')) {
                $table->dropColumn('publish_status');
            }
            if (Schema::hasColumn("courses", 'booking_amount')) {
                $table->dropColumn('booking_amount');
            }
            if (Schema::hasColumn("courses", 'is_allow_prebooking')) {
                $table->dropColumn('is_allow_prebooking');
            }
        });
    }
}
