<?php $__env->startSection('table'); ?>
    <?php
        $table_name='work_processes';
         $LanguageList = getLanguageList();
    ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center mt-50">

                <div class="col-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">  <?php echo e(__('quiz.Topic')); ?> <?php echo e(__('courses.List')); ?></h3>

                            <ul class="d-flex">
                                <li><a class="primary-btn radius_30px   fix-gr-bg" data-bs-toggle="modal"
                                       data-bs-target="#add_topic" href="#"><i
                                            class="ti-plus"></i><?php echo e(__('common.Add')); ?> <?php echo e(__('quiz.Topic')); ?></a></li>
                            </ul>

                        </div>

                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Title')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Description')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $work): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key+1); ?></td>
                                            <td><?php echo e($work->title); ?></td>
                                            <td><?php echo $work->description; ?></td>
                                            <td>
                                                <label class="switch_toggle">
                                                    <input type="checkbox" class="status_enable_disable"
                                                           <?php if(@$work->status == 1): ?> checked
                                                           <?php endif; ?> value="<?php echo e(@$work->id); ?>">
                                                    <i class="slider round"></i>
                                                </label>

                                            </td>
                                            <td>
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu2" data-bs-toggle="dropdown"
                                                            aria-haspopup="true"
                                                            aria-expanded="false">
                                                        <?php echo e(__('common.Action')); ?>

                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu2">
                                                        <a href="#" data-bs-toggle="modal"
                                                           data-bs-target="#editSetting<?php echo e(@$work->id); ?>"
                                                           class="dropdown-item" type="button"><?php echo e(__('common.Edit')); ?></a>


                                                    </div>
                                                </div>

                                            </td>
                                        </tr>

                                        <div class="modal fade admin-query" id="editSetting<?php echo e(@$work->id); ?>">
                                            <div class="modal-dialog modal_1000px modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title"><?php echo e(__('common.Edit')); ?>  </h4>
                                                        <button type="button" class="close " data-bs-dismiss="modal">
                                                            <i class="ti-close "></i>
                                                        </button>
                                                    </div>
                                                    
                                                    <div class="modal-body  student-details header-menu">
                                                        <form action="<?php echo e(route('frontend.workProcessUpdate')); ?>"
                                                              method="POST"
                                                              enctype="multipart/form-data">

                                                            <?php echo csrf_field(); ?>
                                                            <input name="id"
                                                                   value="<?php echo e(@$work->id); ?>"

                                                                   type="hidden">
                                                            <div class="row pt-0">
                                                                <?php if(isModuleActive('FrontendMultiLang')): ?>
                                                                    <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                                                        role="tablist">
                                                                        <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="nav-item">
                                                                                <a class="nav-link  <?php if(auth()->user()->language_code == $language->code): ?> active <?php endif; ?>"
                                                                                   href="#element<?php echo e(@$work->id); ?><?php echo e($language->code); ?>"
                                                                                   role="tab"
                                                                                   data-bs-toggle="tab"><?php echo e($language->native); ?>  </a>
                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="tab-content">
                                                                <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div role="tabpanel"
                                                                         class="tab-pane fade <?php if(auth()->user()->language_code == $language->code): ?> show active <?php endif; ?>  "
                                                                         id="element<?php echo e(@$work->id); ?><?php echo e($language->code); ?>">

                                                                        <div class="row">
                                                                            <div class="col-xl-12">
                                                                                <div class="primary_input mb-25">
                                                                                    <label class="primary_input_label"
                                                                                           for=""> <?php echo e(__('common.Title')); ?>

                                                                                        *</label>
                                                                                    <input class="primary_input_field"
                                                                                           name="title[<?php echo e($language->code); ?>]"
                                                                                           value="<?php echo e(@$work->getTranslation('title',$language->code)); ?>"
                                                                                           placeholder="-"
                                                                                           type="text">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-xl-12">
                                                                                <div class="primary_input mb-25">
                                                                                    <label class="primary_input_label"
                                                                                           for=""> <?php echo e(__('common.Description')); ?>

                                                                                        * </label>
                                                                                    <input class="primary_input_field"
                                                                                           name="description[<?php echo e($language->code); ?>]"
                                                                                           value="<?php echo e(@$work->getTranslation('description',$language->code)); ?>"
                                                                                           placeholder="-"
                                                                                           type="text">
                                                                                </div>
                                                                            </div>


                                                                        </div>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>

                                                            <div class="col-lg-12 text-center pt_15">
                                                                <div class="d-flex justify-content-center">
                                                                    <button class="primary-btn semi_large2  fix-gr-bg"
                                                                            id="save_button_parent" type="submit"><i
                                                                            class="ti-check"></i> <?php echo e(__('common.Update')); ?>

                                                                    </button>
                                                                </div>
                                                            </div>


                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade admin-query" id="add_topic">
                    <div class="modal-dialog modal_1000px modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><?php echo e(__('common.Add New')); ?> <?php echo e(__('quiz.Topic')); ?></h4>
                                <button type="button" class="close " data-bs-dismiss="modal">
                                    <i class="ti-close "></i>
                                </button>
                            </div>
                            <input type="hidden" id="url" value="<?php echo e(url('/')); ?>">
                            <div class="modal-body  student-details header-menu">
                                <form action="<?php echo e(route('frontend.workProcessStore')); ?>" method="POST"
                                      enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="row pt-0">
                                        <?php if(isModuleActive('FrontendMultiLang')): ?>
                                            <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                                role="tablist">
                                                <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="nav-item">
                                                        <a class="nav-link  <?php if(auth()->user()->language_code == $language->code): ?> active <?php endif; ?>"
                                                           href="#element<?php echo e($language->code); ?>"
                                                           role="tab"
                                                           data-bs-toggle="tab"><?php echo e($language->native); ?>  </a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                    <div class="tab-content">
                                        <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div role="tabpanel"
                                                 class="tab-pane fade <?php if(auth()->user()->language_code == $language->code): ?> show active <?php endif; ?>  "
                                                 id="element<?php echo e($language->code); ?>">

                                                <div class="row">

                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for=""><?php echo e(__('quiz.Topic')); ?> <?php echo e(__('common.Title')); ?>

                                                                *</label>
                                                            <input class="primary_input_field"
                                                                   name="title[<?php echo e($language->code); ?>]"
                                                                   placeholder="-"
                                                                   type="text"
                                                                   value="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(__('quiz.Topic')); ?> <?php echo e(__('common.Description')); ?>

                                                            *</label>
                                                        <input class="primary_input_field"
                                                               name="description[<?php echo e($language->code); ?>]"
                                                               value=""
                                                               placeholder="-"
                                                               type="text">
                                                    </div>
                                                </div>

                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="col-lg-12 text-center pt_15">
                                        <div class="d-flex justify-content-center">
                                            <button class="primary-btn semi_large2  fix-gr-bg" id="save_button_parent"
                                                    type="submit"><i
                                                    class="ti-check"></i> <?php echo e(__('common.Add')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/FrontendManage/Resources/views/workProcess.blade.php ENDPATH**/ ?>