<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\Noticeboard\Entities\NoticeType;

class CreateNoticeTypesTable extends Migration
{
    public function up()
    {
        Schema::create('notice_types', function (Blueprint $table) {
            $table->id();
            $table->text('title')->nullable();
            $table->string('color')->default('#36D98B');
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });

        $types = [
            [
                'title' => 'Formal',
                'color' => '#374056'
            ], [
                'title' => 'Informal',
                'color' => '#FF48ED'
            ], [
                'title' => 'Invitation',
                'color' => '#FEB74C'
            ], [
                'title' => 'Warning',
                'color' => '#FF4848'
            ]
        ];

        NoticeType::Insert($types);

    }

    public function down()
    {
        Schema::dropIfExists('notice_types');
    }
}
