<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;

class DigitalFileDownload extends Model
{
    protected $fillable = [];

    protected $table = "digital_file_downloads";
    protected $guarded = [];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id')->withDefault();
    }

    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id', 'id')->withDefault();
    }


    public function order()
    {
        return $this->belongsTo(ProductOrder::class, 'order_id', 'id')->withDefault();
    }

    public function order_package()
    {
        return $this->belongsTo(OrderPackageDetail::class, 'package_id', 'id')->withDefault();
    }

}
