<?php

namespace Modules\Store\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Modules\Setting\Entities\UsedMedia;
use App\Traits\HasTranslations;

class ProductBrand extends Model
{
    use HasTranslations;

    protected $table = "product_brands";
    protected $guarded = ["id"];
    public $translatable = [];

    public function __construct()
    {
        parent::__construct();
        if (isModuleActive('FrontendMultiLang')) {
            $this->translatable = ['name', 'description', 'meta_title', 'meta_description'];
        }
    }

    public static function boot()
    {
        parent::boot();

        static::created(function ($brand) {
            $brand->created_by = Auth::user()->id ?? null;
        });

        static::updating(function ($brand) {
            $brand->updated_by = Auth::user()->id ?? null;
        });

    }


    public function products()
    {
        return $this->hasMany(Product::class, 'brand_id', 'id');
    }

    public function logo_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'logo');
    }

}
