<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Routing\Controller;
use Modules\Store\Entities\DeliveryProcess;
use Modules\Store\Http\Requests\DeliveryProcessRequest;
use Modules\Store\Services\DeliveryProcessService;

class DeliveryProcessController extends Controller
{
    protected $deliveryProcessService;

    public function __construct(DeliveryProcessService $deliveryProcessService)
    {
        $this->deliveryProcessService = $deliveryProcessService;
    }

    public function index()
    {
        $data['items'] = DeliveryProcess::all();
        return view('store::order.delivery_process.index', $data);
    }

    public function process_list()
    {
        $data['items'] = $this->deliveryProcessService->getAll();
        return view('store::order.delivery_process.process_list', $data);
    }

    public function store(DeliveryProcessRequest $request)
    {
        try {
            $this->deliveryProcessService->save($request->except("_token"));
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.delivery.index');
        } catch (\Exception $e) {
            return response()->json(["message" => "Something Went Wrong", "error" => $e->getMessage()], 503);
        }
    }

    public function update(DeliveryProcessRequest $request)
    {
         try {

            $this->deliveryProcessService->update($request->except("_token"), $request->id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.delivery.index');
        } catch (\Exception $e) {

            return response()->json(["message" => "Something Went Wrong", "error" => $e->getMessage()], 503);
        }
    }

    public function destroy($id)
    {
        try {
            $this->deliveryProcessService->delete($id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return back();
        }
    }

    public function edit($id)
    {
        try {
            $data['items'] = $this->deliveryProcessService->getAll();
            $data['edit'] = $this->deliveryProcessService->getById($id);
             return view('store::order.delivery_process.index', $data);
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return back();
        }
    }

}
