<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\SystemSetting\Entities\EmailTemplate;

class AddSurveyAnnouncementNotificaiton extends Migration
{
    public function up()
    {
        $template = EmailTemplate::where('act', 'Survey_Announcement')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'Survey_Announcement';
        }
        $shortCode = '{"name":"student/instructor/specific user name","surveyTitle":"Survey title","time":"Deadline"}';
        $subject = 'Survey Announcement';
        $br = "<br/>";
        $body = "Hello: {{name}} ," . $br . "You have {{surveyTitle}}, you need complete before {{time}}" . $br . " {{footer}}";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();


        $acts = [
            'Survey_Announcement',
        ];
        foreach ($acts as $act) {
            DB::table('role_email_templates')->insert([
                'role_id' => 3,
                'template_act' => $act,
                'status' => 1,
            ]);
            DB::table('role_email_templates')->insert([
                'role_id' => 2,
                'template_act' => $act,
                'status' => 1,
            ]);
            DB::table('role_email_templates')->insert([
                'role_id' => 4,
                'template_act' => $act,
                'status' => 1,
            ]);
        }
    }

    public function down()
    {
        //
    }
}
