
<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title"><?php echo e(__('common.Language List')); ?></h3>
                                <?php if(permissionCheck('languages.store')): ?>
                                    <ul class="d-flex">
                                        <li><a data-bs-toggle="modal" class="primary-btn radius_30px fix-gr-bg" href="#"
                                               onclick="open_add_laguage_modal()"><i
                                                    class="ti-plus"></i><?php echo e(__('common.Add New')); ?> <?php echo e(__('common.Language')); ?>

                                            </a></li>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Name')); ?></th>
                                            <th scope="col"><?php echo e(__('setting.Code')); ?></th>
                                            <th scope="col"><?php echo e(__('setting.Flag')); ?></th>
                                            <th scope="col"><?php echo e(__('setting.RTL/LTL')); ?></th>
                                            <th scope="col"><?php echo e(__('setting.Status')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th><?php echo e(translatedNumber($key+1)); ?></th>
                                                <td><?php echo e($language->name); ?></td>
                                                <td><?php echo e($language->code); ?></td>
                                                <td>
                                                    <?php if($language->flag): ?>
                                                        <div class="profile_info">
                                                            <img src="<?php echo e(asset($language->flag)); ?>" alt="">
                                                        </div>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="primary-btn radius_30px  w-fit  fix-gr-bg">
                                                        <?php echo e($language->rtl==1?'RTL':'LTL'); ?>

                                                    </span>
                                                </td>
                                                <td>
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               <?php if($language->status == 1): ?> checked
                                                               <?php endif; ?> <?php if(!permissionCheck('languages.update_active_status')): ?> disabled
                                                               <?php endif; ?> value="<?php echo e($language->id); ?>"
                                                               onchange="update_active_status(this)">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>
                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            <?php echo e(__('common.Select')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            <?php if(permissionCheck('languages.edit')): ?>
                                                                <a href="#" data-bs-toggle="modal"
                                                                   data-bs-target="#Item_Edit"
                                                                   class="dropdown-item edit_brand"
                                                                   onclick="edit_language_modal(<?php echo e($language->id); ?>)"><?php echo e(__('common.Edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('languages.translate_view')): ?>
                                                                <a href="<?php echo e(route('language.translate_view', $language->id)); ?>"
                                                                   class="dropdown-item edit_brand"><?php echo e(__('setting.Translation')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if($language->id != 19 && permissionCheck('languages.destroy')): ?>
                                                                <a onclick="confirm_modal('<?php echo e(route('languages.destroy', $language->id)); ?>');"
                                                                   class="dropdown-item edit_brand"><?php echo e(__('common.Delete')); ?></a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div id="edit_form">

    </div>
    <div class="modal fade admin-query" id="add_laguage_modal">
        <div class="modal-dialog modal_800px modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo e(__('common.Add New')); ?> <?php echo e(__('common.Language')); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal">
                        <i class="ti-close "></i>
                    </button>
                </div>

                <div class="modal-body">
                    <form action="<?php echo e(route('languages.store')); ?>" method="POST" id="language_addForm"
                          enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
                        <div class="row">

                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('common.Name')); ?> <strong
                                            class="text-danger">*</strong></label>
                                    <input name="name" class="primary_input_field name"
                                           placeholder="<?php echo e(__('common.Name')); ?>" type="text" required>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('setting.Code')); ?> <strong
                                            class="text-danger">*</strong></label>
                                    <input name="code" class="primary_input_field name"
                                           placeholder="<?php echo e(__('setting.Code')); ?>" type="text" required>
                                </div>
                            </div>

                            <div class="col-xl-12 ">
                                <div class="primary_file_uploader  mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('setting.Flag')); ?></label>
                                    <input class="primary-input filePlaceholder" type="text"
                                           id=""
                                           placeholder="<?php echo e(__('courses.Browse Image file')); ?>"
                                           readonly="">
                                    <button class="" type="button">
                                        <label class="primary-btn small fix-gr-bg" style="top: 25px;"
                                               for="document_file_add"><?php echo e(__('common.Browse')); ?></label>
                                        <input type="file" class="d-none fileUpload" name="flag_img"
                                               id="document_file_add">
                                    </button>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('setting.Native Name')); ?><strong
                                            class="text-danger">*</strong></label>
                                    <input name="native" class="primary_input_field name"
                                           placeholder="<?php echo e(__('setting.Native Name')); ?>" type="text" required>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="primary_input">
                                    <div class="row">
                                        <div class="col-md-12 ">
                                            <label class="primary_input_label"
                                                   for=""> <?php echo e(__('setting.Direction')); ?> <strong
                                                    class="text-danger">*</strong>
                                            </label>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-25">
                                            <label class="primary_checkbox d-flex mr-12">
                                                <input type="radio" id="type1"
                                                       name="rtl"
                                                       value="0"
                                                       <?php if(empty(old('rtl'))): ?> checked <?php else: ?>
                                                    <?php echo e(old('rtl')==0?"checked":""); ?>

                                                    <?php endif; ?>
                                                >
                                                <span class="checkmark me-2"></span>LTL
                                            </label>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-25">
                                            <label class="primary_checkbox d-flex mr-12">
                                                <input type="radio" id="type2"
                                                       name="rtl"
                                                       value="1" <?php echo e(old('rtl')==1?"checked":""); ?>>
                                                <span class="checkmark me-2"></span>RTL</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 text-center">
                                <div class="d-flex justify-content-center pt_20">
                                    <button type="submit" class="primary-btn semi_large2 fix-gr-bg"
                                            id="save_button_parent"><i class="ti-check"></i><?php echo e(__('common.Save')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <input type="hidden" name="edit_lang" class="edit_lang" value="<?php echo e(route('languages.edit_modal')); ?>">
    <input type="hidden" name="status_update" class="rtl_status" value="<?php echo e(route('languages.update_rtl_status')); ?>">
    <input type="hidden" name="status_update" class="active_status"
           value="<?php echo e(route('languages.update_active_status')); ?>">
    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <script>
        function update_active_status(el) {
            let url = $('.active_status').val();
            let demoMode = $('#demoMode').val();
            if (demoMode == 1) {
                toastr.warning("For the demo version, you cannot change this", "Warning");
                return false;
            }

            if (el.checked) {
                var status = 1;
            } else {
                var status = 0;
            }
            $.post(url, {
                _token: token,
                id: el.value,
                status: status
            }, function (data) {
                if (data == 1) {
                    toastr.success(
                        "<?php echo e(trans('common.Operation successful')); ?>",
                        "<?php echo e(__('common.Success')); ?>", {
                            timeOut: 5000,
                        }
                    );
                } else {
                    toastr.warning(
                        "Something went wrong",
                        "Warning", {
                            timeOut: 5000,
                        }
                    );
                }
                location.reload();
            });
        }
    </script>
    <script src="<?php echo e(asset('public/backend/js/language.js')); ?>"></script>
    <script type="application/javascript">


        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2,  4, ]);

        let table = $('#lms_table').DataTable(dataTableOptions);


    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Localization/Resources/views/languages/index.blade.php ENDPATH**/ ?>