<?php

namespace Modules\Chat\Http\Controllers;

use App\Models\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\Chat\Entities\Notification;
use Modules\Chat\Notifications\InvitationNotification;
use Modules\Chat\Services\InvitationService;
use Validator;

class InvitationController extends Controller
{
    protected $invitation;

    public function __construct(InvitationService $invitation)
    {
        $this->invitation = $invitation;
    }

    public function index($notification_id =null)
    {
        if ($notification_id){
            Notification::find($notification_id)->update([
                'read_at' => now()
            ]);
        }

        $ownRequest = $this->invitation->myRequest();
        $peopleRequest = $this->invitation->peopleRequest();
        $connectedPeoples = $this->invitation->getAllConnectedUsers();
        return view('chat::invitation', compact('ownRequest','peopleRequest','connectedPeoples'));
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function create(Request $request)
    {
        $rules =[
            'to' => 'required',
        ];
        $validation = Validator::make($request->all(),$rules,validationMessage($rules) );

        if ($validation->fails()){
            Toastr::error(__('chat.something_went_wrong'));
            return redirect()->back();
        }

        $invitation = $this->invitation->invitationCreate($request->to);
        User::find($request->to)->notify(new InvitationNotification($invitation,'You have new connection request!'));

        Toastr::success(trans('common.Operation successful'), trans('common.Success'));

        return redirect()->back();
    }

    public function open(Request $request)
    {
        $rules = [
            'to' => 'required',
        ];
        $validation = Validator::make($request->all(),$rules,validationMessage($rules) );

        if ($validation->fails()){
            Toastr::error(__('chat.something_went_wrong'));
            return redirect()->back();
        }

        $user = User::find($request->to);
        if (!$user->connectedWithLoggedInUser()){
            $invitation = $this->invitation->invitationCreate($request->to, 1);
        }

        return redirect()->route('chat.index', $request->to);
    }

    public function store(Request $request)
    {
        //
    }

    public function show($id)
    {
        return view('chat::show');
    }

    public function edit($id)
    {
        return view('chat::edit');
    }

    public function destroy($id)
    {
        //
    }

    public function action($type, $id)
    {
        $action = $this->invitation->invitationUpdate($type, $id);

        if ($action){
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        }

         Toastr::error(__('chat.something_went_wrong'));
        return redirect()->back();
    }
}
