<?php

namespace Modules\Store\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Modules\Setting\Entities\UsedMedia;
use App\Traits\HasTranslations;

class ProductPublication extends Model
{
    use HasTranslations, Tenantable;

    public $translatable = ['name', 'description'];
    protected $table = "product_publications";
    protected $guarded = ["id"];

    public static function boot()
    {
        parent::boot();
        static::created(function ($model) {
            $model->created_by = Auth::user()->id ?? null;
        });

        static::updating(function ($model) {
            $model->updated_by = Auth::user()->id ?? null;
        });
    }

    public function logo_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'logo');
    }

    public function authors()
    {
        return $this->hasMany(ProductAuthor::class, 'publication_id', 'id');
    }


}
