<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;

class RefundRequestDetail extends Model
{
    protected $fillable = [];
    protected $guarded = ['id'];

    public function refund_products()
    {
        return $this->hasMany(RefundProduct::class);
    }
    public function refund_product_details(){
        return $this->hasMany(OrderPackageDetail::class, 'order_package_id', 'id');
    }
    public function refund_single(){
        return $this->hasOne(RefundProduct::class, 'refund_request_detail_id', 'id');
    }
    public function refund_request(){
        return $this->belongsTo(RefundRequest::class, 'refund_request_id', 'id');
    }
    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id', 'id');
    }
    public function order_package()
    {
        return $this->belongsTo(OrderPackageDetail::class, 'order_package_id', 'id');
    }
    public function process_refund()
    {
        return $this->belongsTo(RefundProcess::class, 'processing_state', 'id');
    }

}
