@extends('backend.master')


@php
    $table_name = 'product_brands';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ _trans('product.Edit Brand') }}</h3>
                            @if (permissionCheck('store.attribute.index'))
                                <li><a class="primary-btn radius_30px   fix-gr-bg"
                                       id="add_student_btn" href="{{route('store.brand.index')}} ">
                                        <i class="ti-list"></i>
                                        {{_trans('store.Brand List')}}</a>
                                </li>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            @if(isModuleActive('FrontendMultiLang'))
                @php
                    $LanguageList = getLanguageList();
                @endphp
            @endif
            <form action="{{route("store.brand.update",$edit->id)}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-lg-8">
                        <div class=" white-box box_shadow_white mb-20">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('store.Brand Info') }}</h3>
                                    </div>
                                </div>
                                @if(isModuleActive('FrontendMultiLang'))
                                    <div class="col-lg-12">
                                        <ul class="nav nav-tabs justify-content-start mt-sm-md-20 mb-30 grid_gap_5"
                                            role="tablist">
                                            @foreach ($LanguageList as $key => $language)
                                                <li class="nav-item">
                                                    <a class="nav-link anchore_color @if (auth()->user()->language_code == $language->code) active @endif"
                                                       href="#element{{$language->code}}" role="tab"
                                                       data-bs-toggle="tab"
                                                       aria-selected="@if (auth()->user()->lang_code == $language->code) true @else false @endif">{{ $language->native }} </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                        <div class="tab-content">
                                            @foreach ($LanguageList as $key => $language)
                                                <div role="tabpanel"
                                                     class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif"
                                                     id="element{{$language->code}}">
                                                    <div class="col-lg-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for=""> {{_trans("common.Name")}} <span
                                                                    class="text-danger">*</span></label>
                                                            <input class="primary_input_field"
                                                                   name="name[{{$language->code}}]"
                                                                   placeholder="{{_trans("common.Name")}}" type="text"
                                                                   value="{{isset($edit)?$edit->getTranslation('name',$language->code):old('name.'.$language->code)}}">
                                                            @error('name.'.auth()->user()->lang_code)
                                                            <span class="text-danger">{{$message}}</span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for=""> {{_trans("common.Description")}} </label>
                                                            <textarea class="lms_summernote"
                                                                      name="description[{{$language->code}}]">{{isset($edit)?$edit->getTranslation('description',$language->code):old('description.'.$language->code)}}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @else
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label" for=""> {{_trans("common.Name")}} <span
                                                    class="text-danger">*</span></label>
                                            <input class="primary_input_field" name="name"
                                                   placeholder="{{_trans("common.Name")}}" type="text"
                                                   value="{{isset($edit)?$edit->name:''}}">
                                            @error('name')
                                            <span class="text-danger">{{$message}}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for=""> {{_trans("common.Description")}} </label>
                                            <textarea class="lms_summernote "
                                                      name="description">{{isset($edit)?$edit->description:''}}</textarea>
                                        </div>
                                    </div>
                                @endif

                                <div class="col-lg-12">
                                    <div class="primary_input mb-30">
                                        <label class="primary_input_label"
                                               for=""> {{_trans("store.Website Link")}}</label>
                                        <input class="primary_input_field" name="link"
                                               placeholder="{{_trans("product.website_link")}}" type="text"
                                               value="{{isset($edit)?$edit->link:''}}">
                                        <span class="text-danger">{{$errors->first('link')}}</span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('common.SEO info') }}</h3>
                                    </div>
                                </div>
                                @if(isModuleActive('FrontendMultiLang'))
                                    <div class="col-lg-12">
                                        <ul class="nav nav-tabs justify-content-start mt-sm-md-20 mb-30 grid_gap_5"
                                            role="tablist">
                                            @foreach ($LanguageList as $key => $language)
                                                <li class="nav-item">
                                                    <a class="nav-link anchore_color @if (auth()->user()->lang_code == $language->code) active @endif"
                                                       href="#melement{{$language->code}}" role="tab"
                                                       data-bs-toggle="tab"
                                                       aria-selected="@if (auth()->user()->lang_code == $language->code) true @else false @endif">{{ $language->native }} </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                        <div class="tab-content">
                                            @foreach ($LanguageList as $key => $language)
                                                <div role="tabpanel"
                                                     class="tab-pane fade @if (auth()->user()->lang_code == $language->code) show active @endif"
                                                     id="melement{{$language->code}}">
                                                    <div class="col-lg-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for=""> {{_trans("common.Meta Title")}}</label>
                                                            <input class="primary_input_field"
                                                                   name="meta_title[{{$language->code}}]"
                                                                   placeholder="{{_trans("common.Meta Title")}}"
                                                                   type="text"
                                                                   value="{{isset($edit)?$edit->getTranslation('meta_title',$language->code):old('meta_title.'.$language->code)}}">
                                                            <span
                                                                class="text-danger">{{$errors->first('meta_title')}}</span>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for=""> {{_trans("common.Meta Description")}}</label>
                                                            <textarea
                                                                class="primary_textarea height_112 meta_description"
                                                                placeholder="{{ _trans('common.Meta Description') }}"
                                                                name="meta_description[{{$language->code}}]"
                                                                spellcheck="false">{{isset($edit)?$edit->getTranslation('meta_description',$language->code):old('meta_description.'.$language->code)}}</textarea>
                                                            <span
                                                                class="text-danger">{{$errors->first('meta_description')}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @else
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for=""> {{_trans("common.Meta Title")}}</label>
                                            <input class="primary_input_field" name="meta_title"
                                                   placeholder="{{_trans("common.Meta Title")}}" type="text"
                                                   value="{{isset($edit)?$edit->meta_title:''}}">
                                            <span class="text-danger">{{$errors->first('meta_title')}}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for=""> {{_trans("common.Meta Description")}}</label>
                                            <textarea class="primary_textarea height_112  meta_description"
                                                      placeholder="{{ _trans('common.Meta Description') }}"
                                                      name="meta_description"
                                                      spellcheck="false">{{isset($edit)?$edit->meta_description:''}}</textarea>
                                            <span class="text-danger">{{$errors->first('meta_description')}}</span>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="white-box">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('common.status_info') }}</h3>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{ _trans('common.Status') }} <span
                                                class="text-danger">*</span></label>
                                        <select class="primary_select mb-25" name="status" id="status">
                                            <option
                                                value="1" {{$edit->status==1? 'selected':'' }} >{{ _trans('common.Publish') }}</option>
                                            <option
                                                value="0" {{$edit->status==0? 'selected':'' }}>{{ _trans('common.Pending') }}</option>
                                        </select>
                                        @error('status')
                                        <span class="text-danger">{{$message}}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('common.logo') }} (150x150)PX</h3>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="logo_div">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="primary_input mb-25">
                                        <x-upload-file
                                            name="logo"
                                            type="image"
                                            media_id="{{isset($edit)?$edit->logo_media?->media_id:''}}"
                                            note="{{__('student.Recommended size')}} (150x150)"
                                        />
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('common.is_featured') }}</h3>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="primary_input mb-25">
                                        <label class="switch_toggle">
                                            <input type="checkbox"
                                                   name="featured" {{$edit->featured==1? 'checked':'' }} >
                                            <div class="slider round"></div>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button class="primary-btn small fix-gr-bg mt-5"><i
                                            class="ti-check"></i>{{_trans("common.Update")}} </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection


@push('scripts')
    <script type="text/javascript">
        (function ($) {
            "use strict";
            $(document).ready(function () {
                $(document).on('change', '#logo', function (event) {
                    getFileName($(this).val(), '#logo_file');
                    imageChangeWithFile($(this)[0], '#logoImg');
                });
            });
        })(jQuery);
    </script>
    <script src="{{ asset('/') }}/Modules/Store/Resources/assets/js/category.js"></script>
@endpush
