@extends('backend.master')

@php
    $table_name = 'products';

@endphp

@php
    $date = request()->get('date');
    $order_status = request()->get('order_status');
    $url = route('store.my_sales_get_data')."?date={$date}&order_status={$order_status}";
@endphp

@section('table')
    {{ $table_name }}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="main-title">
                        <h3 class="mb-20" id="page_title">{{__('product.My Orders')}}</h3>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div class="">
                                    <table id="lms_table" class="table classList">
                                        <thead>
                                        <tr>
                                            <th scope="col"> {{ __('common.SL') }}</th>
                                            <th scope="col"> {{ __('common.Date') }}</th>
                                            <th scope="col"> {{ __('product.Order ID') }}</th>
                                            <th scope="col"> {{ __('common.Email') }}</th>
                                            <th scope="col"> {{ __('product.Order State') }}</th>
                                            <th scope="col">{{ __('product.Order Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>


        </div>
    </section>

    @include('store::partials.delete_modal')

@endsection
@push('scripts')

    <script>

        (function ($) {
            "use strict";

            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [{
                data: 'DT_RowIndex',
                name: 'id'
            },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'order_number',
                    name: 'order.order_number'
                },
                {
                    data: 'customer',
                    name: 'customer',
                    orderable: false
                },
                {
                    data: 'order_state',
                    name: 'order_state'
                },


                {
                    data: 'status',
                    name: 'status'
                },

                {
                    data: 'action',
                    name: 'action',
                    orderable: false
                },

            ];
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
