@extends('backend.master')
@php
    $table_name = 'products';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@push('styles')
    <style>
        .single_img img {
            height: 70px;
        }

        .single_img {
            margin-right: 10px;
        }

        .photo_uploader {
            font-size: 25px;
        }

        .remove_variant_whole_sale {
            background: transparent;
            color: var(--dynamic-text-color);
        }
    </style>
@endpush
@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">


                    <div class="white-box mb_30  student-details header-menu">

                        <div class="row pt-0">
                            @if (isModuleActive('FrontendMultiLang'))
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                                    @foreach ($LanguageList as $key => $language)
                                        <li class="nav-item">
                                            <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                               href="#element{{ $language->code }}" role="tab"
                                               data-bs-toggle="tab">{{ $language->native }} </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>


                        @php
                            $hasPermission =false;
                            $action ='#';
                            $id=0;
                            if (isset($product) && permissionCheck('store.product.update')) {
                               $hasPermission =true;
                                $id=$product->id;
                               $action = route('store.product.update');
                            }elseif (!isset($product) && permissionCheck('store.product.store')) {
                                $hasPermission =true;
                                $action= route('store.product.store');
                            }
                        @endphp
                        <form
                            @if($hasPermission)
                                action="{{$action}}"
                            @endif
                            method="POST" id="category-form"
                            name="category-form" enctype="multipart/form-data">
                            <input type="hidden" name="id" class="product_id" value="{{ $id }}">

                            @csrf


                            <div class="tab-content">
                                @foreach ($LanguageList as $key => $language)
                                    <div role="tabpanel"
                                         class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                         id="element{{ $language->code }}">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="primary_input  mb-25">
                                                    <label class="primary_input_label"
                                                           for="nameInput">{{ __('common.Name') }}
                                                        <strong class="text-danger">*</strong></label>
                                                    <input name="name[{{ $language->code }}]" id="nameInput"
                                                           class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                           placeholder="{{ __('common.Name') }}" type="text"
                                                           value="{{old('name.'.$language->code,isset($product)?$product->getTranslation('title', $language->code):'')}}">

                                                    @if ($errors->has('name'))
                                                        <span class="invalid-feedback d-block mb-10" role="alert">
                                                        <strong>{{ @$errors->first('name') }}</strong>
                                                    </span>
                                                    @endif

                                                </div>

                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-15">
                                                    <label class="primary_input_label" for="">
                                                        {{ __('common.Description') }} </label>
                                                    <textarea class="lms_summernote" id="addAbout" cols="30"
                                                              rows="5"
                                                              name="description[{{ $language->code }}]">{!! old('description.'.$language->code,isset($product)?$product->getTranslation('description', $language->code):'') !!}</textarea>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mt-25 mb-25">
                                                    <label class="primary_input_label" for="">
                                                        {{ _trans('common.Specification') }} </label>
                                                    <textarea class="lms_summernote" id="addAbout" cols="30"
                                                              rows="5"
                                                              name="specification[{{ $language->code }}]">{!! old('specification.'.$language->code,isset($product)?$product->getTranslation('specification', $language->code):'') !!}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-xl-12">
                                                <div class="primary_input  mb-25">
                                                    <label class="primary_input_label" for="">
                                                        {{ _trans('common.Faq') }} </label>
                                                    <textarea class="lms_summernote" id="addAbout" cols="30"
                                                              rows="5"
                                                              name="faq[{{ $language->code }}]">{!! old('faq.'.$language->code,isset($product)?$product->getTranslation('faq', $language->code):'') !!}</textarea>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                @endforeach

                            </div>


                            <div class="row mt-25">
                                <div class="col-lg-4">
                                    @php
                                        if (old('productType')) {
                                           $productType=old('productType');
                                       }
                                       elseif (isset($product) && $product->type == 2) {
                                           $productType=2;
                                       } elseif (isset($product) && $product->type == 1) {
                                           $productType=1;
                                       }else{
                                           $productType=2;
                                       }
                                    @endphp
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <p class="  mb-10">
                                                {{ __('product.Product') }}   {{ __('product.Type') }}
                                                <strong class="text-danger">*</strong>

                                            </p>
                                        </div>
                                        <div class="col-lg-6 mb-25 p-0">
                                            <div class="">
                                                <label class="primary_checkbox d-flex mr-12 "
                                                       for="productTypePhysical">
                                                    <input type="radio" name="productType"
                                                           id="productTypePhysical" value="2"
                                                           {{$productType==2 ? 'checked' : ''}}
                                                           class="common-radio relationButton selectProductType">
                                                    <span
                                                        class="checkmark me-2"></span> {{__('product.Physical')}}
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-25 p-0">
                                            <div class="">
                                                <label class="primary_checkbox d-flex mr-12 "
                                                       for="productTypeVirtual">
                                                    <input type="radio" name="productType"
                                                           id="productTypeVirtual" value="1"
                                                           {{$productType==1 ? 'checked' : ''}}
                                                           class="common-radio relationButton selectProductType">
                                                    <span
                                                        class="checkmark me-2"></span> {{__('product.Virtual')}}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 physicalProduct">
                                    @php
                                        if (old('productOption')) {
                                           $productOption=old('productOption');
                                       }elseif (isset($product) && $product->has_variant == 1) {
                                           $productOption=1;
                                       } elseif (isset($product) && $product->has_variant != 1) {
                                           $productOption=0;
                                       }else{
                                           $productOption=0;
                                       }
                                    @endphp
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <p class="  mb-10">
                                                {{ __('product.Product') }}   {{ __('product.Option') }}
                                                <strong class="text-danger">*</strong>
                                            </p>
                                        </div>
                                        <div class="col-lg-6 mb-25 p-0">
                                            <div class="">
                                                <label class="primary_checkbox d-flex mr-12 "
                                                       for="productOption1">
                                                    <input type="radio" name="productOption"
                                                           id="productOption1" value="0"
                                                           {{$productOption!=1 ? 'checked' : ''}}
                                                           class="common-radio relationButton selectProductOption">
                                                    <span
                                                        class="checkmark me-2"></span> {{__('product.Single')}}
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-25 p-0">
                                            <div class="">
                                                <label class="primary_checkbox d-flex mr-12 "
                                                       for="productOption2">
                                                    <input type="radio" name="productOption"
                                                           id="productOption2" value="1"
                                                           {{$productOption==1 ? 'checked' : ''}}

                                                           class="common-radio relationButton selectProductOption">
                                                    <span
                                                        class="checkmark me-2"></span> {{__('product.Variants')}}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="row mt-25">
                                <div class="col-xl-3 courseBox mb_30">
                                    <label class="primary_input_label" for="author">{{ __('product.Category') }}
                                        <strong class="text-danger">*</strong>
                                    </label>
                                    <select class="primary_select category_id" name="category" id="category_id"
                                        {{ $errors->has('category') ? 'autofocus' : '' }}>
                                        <option
                                            data-display="{{ __('common.Select') }} {{ __('product.Category') }} *"
                                            value="">{{ __('common.Select') }} {{ __('product.Category') }} </option>
                                        @foreach ($categories->where('parent_id',0) as $category)

                                            @php
                                                if (old('category')){
                                                        request()->replace(['category' => old('category')]);

                                                }elseif(isset($product)){
                                                        request()->replace(['category' => $product->category_id]);
                                                    }
                                            @endphp
                                            @include('store::products._single_select_option', [
                                               'category' => $category,
                                               'level' => 1,
                                           ])
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-xl-3 courseBox mb_30" id="subCategoryDiv">
                                    <label class="primary_input_label"
                                           for="author">{{ __('product.Sub Category') }} </label>
                                    <select class="primary_select" name="sub_category" id="subcategory_id"
                                        {{ $errors->has('sub_category') ? 'autofocus' : '' }}>
                                        <option
                                            data-display="{{ __('common.Select') }} {{ __('product.Sub Category') }}  "
                                            value="">{{ __('common.Select') }} {{ __('product.Sub Category') }}
                                        </option>
                                        @if(isset($product))
                                            <option value="{{ @$product->sub_category_id }}" selected>
                                                {{ @$product->subCategory->title }}</option>
                                        @endif
                                    </select>
                                </div>

                                <div class="col-xl-3 virtualProduct">
                                    <div class="primary_input  mb-25">
                                        <label class="primary_input_label" for="author">{{ __('product.Author') }}
                                        </label>
                                        <select class="primary_select" name="product_author" id="product_author"
                                            {{ $errors->has('product_author') ? 'autofocus' : '' }}>
                                            <option
                                                data-display="{{ __('common.Select') }} {{ __('product.Author') }}"
                                                value="">{{ __('common.Select') }}
                                                {{ __('product.Author') }} </option>
                                            @foreach ($authors as $author)
                                                <option value="{{ $author->id }}"
                                                @if(old('product_author'))
                                                    {{ old('product_author') == $author->id ? 'selected' : '' }}
                                                    @elseif(isset($product))
                                                    {{ $author->id == $product->author_id ? 'selected' : '' }}
                                                    @endif
                                                >

                                                    >
                                                    {{ @$author->title }} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>

                                <div class="col-xl-3 physicalProduct">
                                    <div class="primary_input  mb-25">
                                        <label class="primary_input_label" for="brand">{{ __('product.Brand') }}
                                        </label>
                                        <select class="primary_select" name="product_brand" id="product_brand"
                                            {{ $errors->has('product_brand') ? 'autofocus' : '' }}>
                                            <option
                                                data-display="{{ __('common.Select') }} {{ __('product.Brand') }}"
                                                value="">{{ __('common.Select') }}
                                                {{ __('product.Brand') }} </option>
                                            @foreach ($brands as $brand)
                                                <option value="{{ $brand->id }}"
                                                @if(old('product_brand'))
                                                    {{ old('product_brand') == $brand->id ? 'selected' : '' }}
                                                    @elseif(isset($product))
                                                    {{ $brand->id == $product->brand_id ? 'selected' : '' }}
                                                    @endif

                                                >
                                                    {{ @$brand->name }} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>
                                <div class="col-xl-3 ">
                                    <div class="primary_input  mb-25">
                                        <label class="primary_input_label" for="unit">{{ __('product.Unit') }}
                                        </label>
                                        <select class="primary_select" name="product_unit" id="product_unit"
                                            {{ $errors->has('product_unit') ? 'autofocus' : '' }}>

                                            @foreach ($units as $unit)
                                                <option value="{{ $unit->id }}"
                                                @if(old('product_unit'))
                                                    {{ old('product_unit') == $unit->id ? 'selected' : '' }}
                                                    @elseif(isset($product))
                                                    {{ $unit->id == $product->unit_id ? 'selected' : '' }}
                                                    @endif
                                                >
                                                    {{ @$unit->name }} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>
                            </div>


                            <div class="row ">
                                <div class="col-sm-4">
                                    <x-upload-file
                                        media_id="{{isset($product)?$product->pdf_media?->media_id:''}}"
                                        name="pdf_file"
                                        type="pdf"
                                        label="{{ __('product.Product Specification') }} / {{ __('product.Read Some Pages') }}"
                                    />

                                </div>


                                <div class="col-sm-4" id="linkdiv">
                                    <div class="primary_input">
                                        <label class="primary_input_label" for="">
                                            {{ __('product.Video Link') }}</label>
                                        <input class="primary_input_field" name="link" placeholder="-" type="text"
                                               value="{{old('link',isset($product)?$product->link:'')}}">
                                        <span class="text-danger">{{ $errors->first('link') }}</span>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class=" mb-25 mb-25">
                                        <x-upload-file
                                            name="thumbimage[]"
                                            type="image"
                                            media_id="{{isset($product)?$product->thumbnail_media?->media_id:''}}"
                                            multiple="true"
                                            label="{{ __('product.Product Thumbnails') }}"
                                        />

                                    </div>
                                </div>


                                <div class="col-xl-4 virtualProduct">
                                    <div class="  mb-35">

                                        <x-upload-file
                                            media_id="{{isset($product)?$product->soft_file_media?->media_id:''}}"
                                            required="true"
                                            type="all"
                                            name="soft_file"
                                            label="{{ _trans('product.Ebook/Downloadable File') }}"
                                        />
                                    </div>
                                </div>

                                <div class=" col-sm-4 virtualProduct">

                                    <div class="row">
                                        <div class="col-lg-12">
                                            <p class="  mb-10">
                                                {{ __('product.Readable') }}
                                                <strong class="text-danger">*</strong>

                                            </p>
                                        </div>
                                        <div class="col-lg-6 mb-25 p-0">
                                            <div class="">
                                                <label class="primary_checkbox d-flex mr-12 "
                                                       for="readAbleNo">
                                                    <input type="radio" name="readAble"
                                                           id="readAbleNo" value="0"

                                                           {{old('readAble',isset($product)?$product->is_readable:0)!=1?'checked':''}}
                                                           class="common-radio relationButton selectReadAble">
                                                    <span
                                                        class="checkmark me-2"></span> {{__('product.No')}}
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-25 p-0">
                                            <div class="">
                                                <label class="primary_checkbox d-flex mr-12 "
                                                       for="readAbleYes">
                                                    <input type="radio" name="readAble"
                                                           id="readAbleYes" value="1"
                                                           {{old('readAble',isset($product)?$product->is_readable:0)==1?'checked':''}}

                                                           class="common-radio relationButton selectReadAble">
                                                    <span
                                                        class="checkmark me-2"></span> {{__('product.Yes')}}
                                                </label>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 mb-25">
                                    <div class="checkbox_wrap d-flex align-items-center">
                                        <label for="is_free" class="switch_toggle me-2">
                                            <input type="checkbox" id="is_free" value="1" name="is_free"
                                            @if(isset($product) && $product->has_variant != 1)
                                                {{ $product->is_free == 1?'checked':'' }}
                                                @endif

                                            >
                                            <i class="slider round"></i>
                                        </label>
                                        <label
                                            class="mb-0">{{ __('product.This product is a free product') }}</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row  ">

                                <div class="col-sm-4 singleProduct " id="price_div">
                                    <div class="must_price">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="">{{ __('product.Price') }} </label>
                                            <input class="primary_input_field" name="price" placeholder="-"
                                                   id="addPrice"
                                                   type="text"
                                                   value="{{ old('price',isset($product)?$product->price:0) }}">
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 must_price" id="price_div">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="discount"> {{ __('common.Discount') }}</label>
                                        <input class="primary_input_field" name="discount" id="discount"
                                               placeholder="{{ __('common.Discount') }}" type="number" min="0"
                                               value="{{old('discount',isset($product)?$product->discount:0)}}">
                                        <span class="text-danger"
                                              id="error_discunt">{{ $errors->first('discount')}}</span>
                                    </div>
                                </div>
                                <div class="col-lg-4 must_price" id="price_div">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="discount_type">{{ __('product.discount_type')}}</label>
                                        <select class="primary_select mb-25" name="discount_type"
                                                id="discount_type">
                                            <option data-display="{{ __('common.Select') }}"
                                                    value="">{{ __('common.Select') }}</option>
                                            <option value="1"
                                                    @if( old('discount_type',isset($product)?$product->discount_type:'') == 1) selected @endif>{{ __('common.Amount') }}</option>
                                            <option value="2"
                                                    @if( old('discount_type',isset($product)?$product->discount_type:'') == 2) selected @endif>{{ __('product.Percentage') }}</option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                            <div class="row  physicalProduct">
                                <div class="align-items-center d-flex justify-content-start  mb_30 row"
                                     id="inventoryDiv">
                                    <div class="col-sm-3">
                                        <div class="checkbox_wrap d-flex align-items-center">
                                            <label for="isStockManaged" class="switch_toggle me-2">
                                                <input type="checkbox" id="isStockManaged" value="1"
                                                       {{old('stock_manage',isset($product)?$product->stock_manage:0)==1?'checked':''}}
                                                       name="stock_manage">
                                                <i class="slider round"></i>
                                            </label>
                                            <label class="mb-0">{{ __('product.Stock Manage') }}</label>
                                        </div>
                                    </div>

                                    <div class="col-sm-3 hasStockManage  " id="inventoryQntyDiv"
                                         style="display: none">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="">{{ __('product.Stock Quantity') }}
                                            </label>
                                            <input class="primary_input_field" name="stock_quantity" placeholder="-"
                                                   id="stock_quantity" type="text"
                                                   value="{{ old('stock_quantity',isset($product)?$product->stock_quantity:0) }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 variantProduct attribute_div" id="attribute_select_div">
                                    @include('store::products._attribute_list_select')
                                </div>


                            </div>


                            <div class="row variantProduct" id="valueTable">

                            </div>

                            <div class="col-lg-12 text-center">
                                <div class="d-flex justify-content-center pt_20">
                                    <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                            data-bs-toggle="tooltip"
                                            id="save_button_parent">
                                        <i class=" fa fa-check "></i>
                                        @if(isset($product))
                                            {{ __('common.Update') }}

                                        @else
                                            {{ __('common.Save') }}

                                        @endif

                                    </button>


                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>

@endsection

@push('scripts')
    <script src="{{ asset('/') }}/Modules/Store/Resources/assets/js/product.js{{assetVersion()}}"></script>
    <script>

        (function ($) {
            "use strict";
            $(document).on('change', '.upload_img_for_product', function (event) {
                let upload_div = $(this).data('upload_div');
                let count = $(this).data('count');
                uploadImage($(this)[0], upload_div, count);
            });

            function uploadImage(data, divId, count) {
                if (data.files) {
                    if (data.files.length > 6) {
                        toastr.error("{{__('defaultTheme.maximum_6_image_can_upload')}}", "{{__('common.error')}}");
                        data.value = '';
                    } else {
                        $.each(data.files, function (key, value) {
                            $(divId).empty();
                            $(count).text(data.files.length + '/4');
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $(divId).append(
                                    `<div class="single_img">
                                    <img src="` + e.target.result + `" alt="">
                                </div>`);
                            };
                            reader.readAsDataURL(value);
                        });
                    }
                }
            }
        })(jQuery);

    </script>
@endpush
