<table class="table Crm_table_active3">
    <thead>
    <tr>
        <th scope="col">{{__('common.SL')}}</th>
        <th scope="col">{{_trans('store.pickup_location')}}</th>
        <th scope="col">{{__('common.Phone')}}</th>
        <th scope="col">{{__('common.Address')}}</th>
        <th scope="col">{{_trans('store.pin_code')}}</th>
        <th scope="col">{{_trans('store.is_active')}}</th>
        <th scope="col">{{_trans('store.is_default')}}</th>
        <th scope="col">{{__('common.Action')}}</th>
    </tr>
    </thead>
    <tbody>
    @foreach($pickup_locations as $key => $row)
        <tr>
            <th>{{translatedNumber( $key+1) }}</th>
            <td>{{ $row->pickup_location }}</td>
            <td>{{ translatedNumber($row->phone) }}</td>
            <td>{{ $row->address }}</td>
            <td>{{ $row->pin_code }}</td>
            <td>
                <label class="switch_toggle">
                    <input type="checkbox"
                           @if ($row->status == 1) checked
                           @endif class="status_change"
                           value="{{ $row->id }}" data-id="{{ $row->id }}">
                    <div class="slider round"></div>
                </label>
            </td>
            <td>
                <label class="switch_toggle" for="default_checkbox{{ $row->id }}">
                    <input type="checkbox" id="default_checkbox{{ $row->id }}"
                           @if ($row->is_default == 1) checked
                           @endif  class="set_default"
                           value="{{ $row->id }}" data-id="{{ $row->id }}">
                    <div class="slider round"></div>
                </label>
            </td>
            <td>
                <div class="dropdown CRM_dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenu2"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        {{__('common.select')}}
                    </button>
                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu2">

                        <a class="dropdown-item view_row" data-id="{{$row->id}}"
                           type="button">{{__('common.view')}}</a>

                        <a class="dropdown-item"
                           href="{{ route('store.pickuplocation.edit', $row->id) }}">{{__('common.edit')}}</a>

                        <a class="dropdown-item delete_row" data-id="{{$row->id}}">{{__('common.delete')}}</a>

                    </div>
                </div>

            </td>
        </tr>
    @endforeach
    </tbody>
</table>
