<?php

namespace Modules\Tax\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class TaxSetting extends Model
{
    use Tenantable;

    protected $guarded = [];


    public static function boot()
    {
        parent::boot();
        self::created(function ($model) {
            Cache::forget('TaxSetting_' . SaasDomain());

        });
        self::updated(function ($model) {
            Cache::forget('TaxSetting_' . SaasDomain());

        });
        self::deleted(function ($model) {
            Cache::forget('TaxSetting_' . SaasDomain());
        });
    }

    public static function getData()
    {
        return Cache::rememberForever('TaxSetting_' . SaasDomain(), function () {
            $setting = DB::table('tax_settings')->where('lms_id', SaasInstitute()->id)->first();
            if (!$setting) {
                $setting = DB::table('tax_settings')->first();
            }
            return $setting;
        });
    }
}
