<?php

Route::prefix('twofa')->group(function () {
    Route::post('/verify', 'TwoFAController@verify')->name('2fa')->middleware('auth');
    Route::get('/regenerate', 'TwoFAController@regenerate')->name('2fa.regenerate')->middleware('auth');
    Route::get('/two_step_verification', 'TwoFAController@index')->name('two_step_verification');
    Route::get('/resend_verification_code', 'TwoFAController@resendVerificationCode')->name('resend_verification_code');

    Route::get('/settings', 'TwoFAController@settings')->name('admin.two_fa.settings')->middleware(['auth','RoutePermissionCheck:admin.two_fa.settings']);
    Route::post('/settings-update', 'TwoFAController@settingsUpdate')->name('admin.two_fa.settings.update')->middleware(['auth','RoutePermissionCheck:admin.two_fa.settings']);
});
