<div class="modal fade admin-query" id="editModal" x-data="{custom:false}">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?php echo e(__('footer.Edit Link')); ?></h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="ti-close "></i></button>
            </div>
            <form method="POST" action="<?php echo e(route('footerSetting.footer.widget-update')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>
                <input type="hidden" name="id" id="widgetEditId">
                <div class="modal-body">
                    <div class="row pt-0">
                        <?php if(isModuleActive('FrontendMultiLang')): ?>
                            <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                role="tablist">
                                <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link  <?php if(auth()->user()->language_code == $language->code): ?> active <?php endif; ?>"
                                           href="#element<?php echo e($language->code); ?>"
                                           role="tab"
                                           data-bs-toggle="tab"><?php echo e($language->native); ?>  </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                    <div class="tab-content">
                        <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div role="tabpanel"
                                 class="tab-pane fade <?php if(auth()->user()->language_code == $language->code): ?> show active <?php endif; ?>  "
                                 id="element<?php echo e($language->code); ?>">
                                <div class="row">
                                    <div class="col-md-12 mt-30">
                                        <div class="input-effect">
                                            <label class="primary_input_label mt-1"><?php echo e(__('footer.Page Name')); ?> <span class="required_mark">*</span>
                                            </label>
                                            <input class="primary_input_field name form-control" type="text"
                                                   name="name[<?php echo e($language->code); ?>]"
                                                   id="widget_name_edit_<?php echo e($language->code); ?>"
                                                   autocomplete="off" value="">


                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="row">


                        <div id="editCategoryFieldDiv" class="col-lg-12 mt-30">
                            <div class="input-effect">
                                <select class="primary_select" name="category"
                                        id="editCategory">
                                    <option data-display="<?php echo e(__('footer.Widget Title')); ?>- *" value="">
                                        --<?php echo e(__('footer.Widget Title')); ?>--
                                    </option>
                                    <option value="1"><?php echo e(Settings('footer_section_one_title')); ?></option>
                                    <option value="2"><?php echo e(Settings('footer_section_two_title')); ?></option>
                                    <option value="3"><?php echo e(Settings('footer_section_three_title')); ?></option>
                                    <?php if(Settings('frontend_active_theme')=='tvt'): ?>
                                        <option value="4"><?php echo e(Settings('footer_section_four_title')); ?></option>
                                    <?php endif; ?>
                                </select>
                                <span class="focus-border"></span>
                            </div>
                            <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        


                        <div class="col-lg-12 mt-30">
                            <div class="primary_input ">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label class="primary_input_label"
                                               for="    "> <?php echo e(__('setting.Custom Link')); ?></label>
                                    </div>

                                    <div class="col-md-6 ps-0">
                                        <div class="row">
                                            <div class="col-4 ">
                                                <label class="primary_checkbox d-flex mr-12"
                                                       for="edit_yes">
                                                    <input type="radio"
                                                           class="common-radio editCustom"
                                                           id="edit_yes"
                                                           x-on:change="custom = true"
                                                           name="custom"

                                                           value="1">
                                                    <span
                                                        class="checkmark me-2"></span> <?php echo e(__('common.Yes')); ?>

                                                </label>
                                            </div>
                                            <div class="col-4">
                                                <label class="primary_checkbox d-flex mr-12"
                                                       for="edit_no">
                                                    <input type="radio"
                                                           class="common-radio editCustom "
                                                           id="edit_no"
                                                           name="custom"
                                                           x-on:change="custom = false"
                                                           checked
                                                           value="0">
                                                    <span
                                                        class="checkmark me-2"></span> <?php echo e(__('common.No')); ?>

                                                </label>
                                            </div>
                                        </div>


                                    </div>

                                </div>
                            </div>

                        </div>

                        <div class="col-lg-12 mt-30 " id="editPageFieldDiv" x-show="!custom">
                            <div class="input-effect">
                                <label class="primary_input_label mt-1"><?php echo e(__('footer.Select Page')); ?> <span class="required_mark">*</span>
                                </label>
                                <select class="primary_select "
                                        name="page" id="editPage">
                                    <option data-display="<?php echo e(__('footer.Select Page')); ?> " value="">
                                        --<?php echo e(__('footer.Select Page')); ?>--
                                    </option>

                                    <?php $__currentLoopData = $staticPageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($page->slug); ?>"><?php echo e($page->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="focus-border"></span>
                            </div>
                            <?php $__errorArgs = ['page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div id="editCustomFieldDiv" class="col-lg-12 mt-30" x-show="custom">
                            <div class="input-effect">
                                <label class="primary_input_label mt-1"><?php echo e(__('footer.Custom Link')); ?> <span class="required_mark">*</span>
                                </label>
                                <input class="primary_input_field name form-control" type="url"
                                       name="custom_link"
                                       id="custom_link"
                                       placeholder="https://google.com"
                                       autocomplete="off" value="">

                                <span class="focus-border"></span>
                            </div>
                            <?php $__errorArgs = ['page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>


                        <div class="mt-40 w-100 d-flex justify-content-center">
                            <button type="button" class="primary-btn tr-bg  me-3"
                                    data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>
                            <div class="tooltip-wrapper" data-title="" data-original-title="" title="">
                                <button type="submit" class="primary-btn fix-gr-bg tooltip-wrapper "
                                        data-original-title="" title="">
                                    <i class="ti-check"></i>
                                    <?php echo e(__('common.Update')); ?> </button>
                            </div>

                        </div>
                    </div>


                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /home/minialms/card.minialms.com/Modules/FooterSetting/Resources/views/footer/components/widget_edit.blade.php ENDPATH**/ ?>