
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('Modules\Appointment\Resources\assets\css\appointment.css')); ?>"/>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        (function ($) {
            "use strict";

            $(document).on('click', '.schedule_status_enable_disable', function () {


                let status = 0;
                if ($(this).is(':checked')) {
                    status = 1;
                } else {
                    status = 0;
                }

                let id = $(this).val();
                let url = $("#url").val();
                let table = $("#table_name").val();


                let formData = {
                    id: id,
                    table: table,
                    status: status,
                };
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "status-enable-disable",
                    success: function (data) {
                        if (data.warning) {
                            toastr.warning(data.warning, 'Error');
                        } else if (data.success) {
                            toastr.success(data.success, 'Success');
                        } else if (data.error) {
                            toastr.error(data.error, 'Error');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseJSON);
                        toastr.error('Something went wrong!', 'Falied');
                    },
                });


            })
            $(document).on('click', '.move_slot', function () {
                if ($('.move_slot').is(":checked")) {
                    var status = 1;
                } else {
                    var status = 0;
                }

                if (status == 1) {
                    $('.moveSlotDiv').removeClass('d-none');
                } else {
                    $('.moveSlotDiv').addClass('d-none');
                }
            })
            $(document).ready(function () {
                let availableMessage = "<?php echo e(isset($editInstructor) ? $editInstructor->is_available  : 1); ?>";
                availableMessageHideShow(availableMessage);
                $(document).on('click', '#availableMessage', function () {
                    if ($('#availableMessage').is(":checked")) {
                        var availableMessage = 1;
                    } else {
                        var availableMessage = 0;
                    }

                    availableMessageHideShow(availableMessage);
                });
            });

            function availableMessageHideShow(availableMessage) {

                if (availableMessage == 0) {
                    $('#availableMessageNo').removeClass('d-none');
                    $('#availableMessageYes').addClass('d-none');
                } else {
                    $('#availableMessageNo').addClass('d-none');
                    $('#availableMessageYes').removeClass('d-none');

                }

            }

            addEducation = () => {
                var countEducation = parseFloat($('#educationDiv').val()) + 1;
                $('#educationDiv').val(countEducation);
                var newDiv = `<div class="row">
                <div class="col-xl-2">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">
                            <?php echo e(__('appointment.Duration (Years)')); ?></label>
                        <input class="primary_input_field" name="education[${countEducation}][duration]"
                            placeholder="-" id="addDuration" type="text"
                            value="<?php echo e(old('duration')); ?>">
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">
                            <?php echo e(__('appointment.Degree')); ?></label>
                        <input class="primary_input_field" name="education[${countEducation}][degree]"
                            placeholder="-" id="addDegree" type="text"
                            value="<?php echo e(old('education_degree')); ?>">
                    </div>
                </div>

                <div class="col-xl-4">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">
                            <?php echo e(__('appointment.Institute')); ?></label>
                        <input class="primary_input_field" name="education[${countEducation}][institute]"
                            placeholder="-" id="addInstitute" type="text"
                            value="<?php echo e(old('institute')); ?>">
                    </div>
                </div>
                <?php if(auth()->check() && auth()->user()->role_id == 1): ?>
                <div class="col-xl-1 mt-33">
                    <label class="primary_checkbox d-flex mr-12">
                        <input type="checkbox" id="verified" name="education[${countEducation}][is_verified]">
                            <span class="checkmark me-2"></span><?php echo e(__('appointment.Verified')); ?>

                </label>
            </div>
<?php endif; ?>
                <div class="col-xl-1 mt-33">
                    <button class="removeEducationBtn primary-btn icon-only fix-gr-bg fl-r"
                        type="button">
                        <span class="ti-trash"></span> </button>
                </div>
            </div>`;
                $("#copyEducation").append(newDiv);
            }

            addCertificate = () => {
                var countCertificate = parseFloat($('#certificateDiv').val()) + 1;
                $('#certificateDiv').val(countCertificate);
                var newDiv = `<div class="row">
                            <div class="col-xl-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <?php echo e(__('appointment.Duration (Years)')); ?></label>
                                    <input class="primary_input_field" name="certificate[${countCertificate}][duration]"
                                        placeholder="-" id="addDuration" type="text"
                                        value="<?php echo e(old('duration')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <?php echo e(__('appointment.Title')); ?></label>
                                    <input class="primary_input_field" name="certificate[${countCertificate}][title]"
                                        placeholder="-" id="addTitle" type="text"
                                        value="<?php echo e(old('title')); ?>">
                                </div>
                            </div>

                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <?php echo e(__('appointment.Institute')); ?></label>
                                    <input class="primary_input_field" name="certificate[${countCertificate}][institute]"
                                        placeholder="-" id="addInstitute" type="text"
                                        value="<?php echo e(old('institute')); ?>">
                                </div>
                            </div>
                <?php if(auth()->check() && auth()->user()->role_id == 1): ?>
                <div class="col-xl-1 mt-33">
                    <label class="primary_checkbox d-flex mr-12">
                        <input type="checkbox" id="verified" name="certificate[${countCertificate}][is_verified]"
                                            <?php echo e(isset($Verified) ? ($Verified == 1 ? 'checked' : '') : ''); ?>>
                                        <span class="checkmark me-2"></span><?php echo e(__('appointment.Verified')); ?>

                </label>
            </div>
<?php endif; ?>
                <div class="col-xl-1 mt-33">
                    <button class="removeCertificateBtn primary-btn icon-only fix-gr-bg fl-r"
                        type="button">
                        <span class="ti-trash"></span> </button>
                </div>
            </div>`;
                $("#copyCertificate").append(newDiv);
            }

            addExperience = () => {
                var countExperience = parseFloat($('#experienceDiv').val()) + 1;
                $('#experienceDiv').val(countExperience);
                var newDiv = `<div class="row">
                            <div class="col-xl-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <?php echo e(__('appointment.Duration (Years)')); ?></label>
                                    <input class="primary_input_field" name="experience[${countExperience}][duration]"
                                        placeholder="-" id="addDuration" type="text"
                                        value="<?php echo e(old('duration')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <?php echo e(__('appointment.Designation')); ?></label>
                                    <input class="primary_input_field" name="experience[${countExperience}][designation]"
                                        placeholder="-" id="addDegree" type="text"
                                        value="<?php echo e(old('degree')); ?>">
                                </div>
                            </div>

                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <?php echo e(__('appointment.Institute')); ?></label>
                                    <input class="primary_input_field" name="experience[${countExperience}][institute]"
                                        placeholder="-" id="addInstitute" type="text"
                                        value="<?php echo e(old('institute')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-2 mt-45">
                                <button class="removeWorkExperienceBtn primary-btn icon-only fix-gr-bg fl-r"
                                    type="button">
                                    <span class="ti-trash"></span> </button>
                            </div>
                        </div>`
                $("#copyWorkExperience").append(newDiv);
            }

            addTeachingCategory = () => {
                var countTeachingCategory = parseFloat($('#teachingCategoryDiv').val()) + 1;
                $('#teachingCategoryDiv').val(countTeachingCategory);
                var newDiv = `   <div class="row mt-25">
                            <div class="col-xl-4">
                                <label class="primary_input_label"
                                    for="category"><?php echo e(__('courses.Category')); ?></label>
                                <select class="primary_select teachingCategory" name="teachingCategory[${countTeachingCategory}][category]" id="teachingCategory" data-serial_id = "${countTeachingCategory}"
                                    <?php echo e($errors->has('category') ? 'autofocus' : ''); ?>>
                                    <option data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?> *"
                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?> </option>
                                        <?php if(isset($categories)): ?>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>"><?php echo e(@$category->name); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </select>
            </div>

            <div class="col-xl-4 courseBox mt-30 teachingSubCategoryDiv" id="teachingSubCategoryDiv_${countTeachingCategory}">
                                <select class="primary_select teachingSubCategory" name="teachingCategory[${countTeachingCategory}][sub_category]" id="teachingSubCategory_${countTeachingCategory}"
                                    <?php echo e($errors->has('sub_category') ? 'autofocus' : ''); ?>>
                                    <option
                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Sub Category')); ?>  "
                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Sub Category')); ?>

                </option>
            </select>
        </div>

        <div class="col-xl-3">
            <label class="primary_input_label"
                for="category"><?php echo e(__('courses.Level')); ?></label>
                                <select class="primary_select" name="teachingCategory[${countTeachingCategory}][level]" id="category">
                                    <option data-display="<?php echo e(__('appointment.Select Level')); ?>" value="">
                                        <?php echo e(__('appointment.Select Level')); ?></option>
                                        <?php if(isset($levels)): ?>
                <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($level->id); ?>"><?php echo e(@$level->title); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </select>
            </div>
            <div class="col-xl-1 mt-45">
                <button class="removeTeachingCategoryBtn primary-btn icon-only fix-gr-bg fl-r"
                    type="button">
                    <span class="ti-trash"></span> </button>
            </div>
        </div>`;
                $("#copyTeachingCategory").append(newDiv);
                $('.primary_select').niceSelect('destroy');
                $(".primary_select").niceSelect();
            }

            addTeachingLanguage = () => {
                var countTeachingLanguage = parseFloat($('#teachingLanguageDiv').val()) + 1;
                $('#teachingLanguageDiv').val(countTeachingLanguage);
                var newDiv = ` <div class="row mt-25">
                            <div class="col-xl-6">
                                <label class="primary_input_label"
                                    for="category"><?php echo e(__('common.Language')); ?></label>
                                <select class="primary_select" name="teachingLanguage[${countTeachingLanguage}][language]" id="language">
                                    <option data-display="<?php echo e(__('common.Select Language')); ?>"
                                        value=""><?php echo e(__('common.Select Language')); ?></option>
                                        <?php if(isset($languages)): ?>
                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($lang->id); ?>"><?php echo e(@$lang->name); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </select>
            </div>
            <div class="col-xl-5">
                <label class="primary_input_label"
                    for="category"><?php echo e(__('courses.Level')); ?></label>
                                <select class="primary_select" name="teachingLanguage[${countTeachingLanguage}][level]" id="langauageLevel[]">
                                    <option data-display="<?php echo e(__('appointment.Select Level')); ?>" value="">
                                        <?php echo e(__('appointment.Select Level')); ?></option>
                                        <?php if(isset($levels)): ?>
                <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($level->id); ?>"><?php echo e(@$level->title); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </select>
            </div>
            <div class="col-xl-1 mt-45">
                <button class="removeTeachingLanguageBtn primary-btn icon-only fix-gr-bg fl-r"
                    type="button">
                    <span class="ti-trash"></span> </button>
            </div>
        </div>`;
                $("#copyTeachingLanguage").append(newDiv);
                $('.primary_select').niceSelect('destroy');
                $(".primary_select").niceSelect();
            }
            addSocialMedia = () => {
                var countSocialMedia = parseFloat($('#educationDiv').val()) + 1;
                $('#educationDiv').val(countSocialMedia);
                var newDiv = `<div class="row">
                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                        <label class="primary_input_label" for=""><?php echo e(__('frontendmanage.Icon')); ?> <strong
                                            class="text-danger">*</strong></label>
                                    <select
                                        class="primary_select mb-25  <?php echo e(@$errors->has('icon') ? ' is-invalid' : ''); ?>"
                                        name="social[${countSocialMedia}][icon]" id="icon" required>
                                        <?php echo socialIconList(); ?>

                </select>
            </div>
        </div>

        <div class="col-xl-7">
            <div class="primary_input mb-25">
                <label class="primary_input_label" for=""> <?php echo e(__('common.URL')); ?></label>
                                    <input class="primary_input_field" name="social[${countSocialMedia}][url]" placeholder="-" id="addFacebook"
                                        type="text" >
                                </div>
                            </div>
                            <div class="col-xl-1 mt-33">
                                    <button class="removeSocialMediaBtn primary-btn icon-only fix-gr-bg fl-r"
                                        type="button">
                                        <span class="ti-trash"></span> </button>
                                </div>
                        </div>`;
                $("#copySocialMedia").append(newDiv);
                $('.primary_select').niceSelect('destroy');
                $(".primary_select").niceSelect();
            }
            $(document).on("click", '.removeEducationBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeCertificateBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeWorkExperienceBtn', function (e) {
                $(this).parent().parent().remove();
            });

            $(document).on("click", '.removeTeachingCategoryBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeTeachingLanguageBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeSocialMediaBtn', function (e) {
                $(this).parent().parent().remove();
            });

            $('.cityList').select2({
                ajax: {
                    url: '<?php echo e(route('ajaxCounterCity')); ?>',
                    type: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            search: params.term,
                            page: params.page || 1,
                            id: $('#state').find(':selected').val(),
                        }
                        return query;
                    },
                    cache: false
                }
            });

            $('.stateList').select2({
                ajax: {
                    url: '<?php echo e(route('ajaxCounterState')); ?>',
                    type: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            search: params.term,
                            page: params.page || 1,
                            id: $('#country').find(':selected').val(),
                        }
                        return query;
                    },
                    cache: false
                }
            });


        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Appointment/Resources/views/layouts/master.blade.php ENDPATH**/ ?>