@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{ asset('Modules\Appointment\Resources\assets\css\appointment.css') }}"/>
@endpush
@push('scripts')
    <script>
        (function ($) {
            "use strict";

            $(document).on('click', '.schedule_status_enable_disable', function () {


                let status = 0;
                if ($(this).is(':checked')) {
                    status = 1;
                } else {
                    status = 0;
                }

                let id = $(this).val();
                let url = $("#url").val();
                let table = $("#table_name").val();


                let formData = {
                    id: id,
                    table: table,
                    status: status,
                };
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "status-enable-disable",
                    success: function (data) {
                        if (data.warning) {
                            toastr.warning(data.warning, 'Error');
                        } else if (data.success) {
                            toastr.success(data.success, 'Success');
                        } else if (data.error) {
                            toastr.error(data.error, 'Error');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseJSON);
                        toastr.error('Something went wrong!', 'Falied');
                    },
                });


            })
            $(document).on('click', '.move_slot', function () {
                if ($('.move_slot').is(":checked")) {
                    var status = 1;
                } else {
                    var status = 0;
                }

                if (status == 1) {
                    $('.moveSlotDiv').removeClass('d-none');
                } else {
                    $('.moveSlotDiv').addClass('d-none');
                }
            })
            $(document).ready(function () {
                let availableMessage = "{{ isset($editInstructor) ? $editInstructor->is_available  : 1 }}";
                availableMessageHideShow(availableMessage);
                $(document).on('click', '#availableMessage', function () {
                    if ($('#availableMessage').is(":checked")) {
                        var availableMessage = 1;
                    } else {
                        var availableMessage = 0;
                    }

                    availableMessageHideShow(availableMessage);
                });
            });

            function availableMessageHideShow(availableMessage) {

                if (availableMessage == 0) {
                    $('#availableMessageNo').removeClass('d-none');
                    $('#availableMessageYes').addClass('d-none');
                } else {
                    $('#availableMessageNo').addClass('d-none');
                    $('#availableMessageYes').removeClass('d-none');

                }

            }

            addEducation = () => {
                var countEducation = parseFloat($('#educationDiv').val()) + 1;
                $('#educationDiv').val(countEducation);
                var newDiv = `<div class="row">
                <div class="col-xl-2">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">
                            {{ __('appointment.Duration (Years)') }}</label>
                        <input class="primary_input_field" name="education[${countEducation}][duration]"
                            placeholder="-" id="addDuration" type="text"
                            value="{{ old('duration') }}">
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">
                            {{ __('appointment.Degree') }}</label>
                        <input class="primary_input_field" name="education[${countEducation}][degree]"
                            placeholder="-" id="addDegree" type="text"
                            value="{{ old('education_degree') }}">
                    </div>
                </div>

                <div class="col-xl-4">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">
                            {{ __('appointment.Institute') }}</label>
                        <input class="primary_input_field" name="education[${countEducation}][institute]"
                            placeholder="-" id="addInstitute" type="text"
                            value="{{ old('institute') }}">
                    </div>
                </div>
                @if (auth()->check() && auth()->user()->role_id == 1)
                <div class="col-xl-1 mt-33">
                    <label class="primary_checkbox d-flex mr-12">
                        <input type="checkbox" id="verified" name="education[${countEducation}][is_verified]">
                            <span class="checkmark me-2"></span>{{ __('appointment.Verified') }}
                </label>
            </div>
@endif
                <div class="col-xl-1 mt-33">
                    <button class="removeEducationBtn primary-btn icon-only fix-gr-bg fl-r"
                        type="button">
                        <span class="ti-trash"></span> </button>
                </div>
            </div>`;
                $("#copyEducation").append(newDiv);
            }

            addCertificate = () => {
                var countCertificate = parseFloat($('#certificateDiv').val()) + 1;
                $('#certificateDiv').val(countCertificate);
                var newDiv = `<div class="row">
                            <div class="col-xl-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        {{ __('appointment.Duration (Years)') }}</label>
                                    <input class="primary_input_field" name="certificate[${countCertificate}][duration]"
                                        placeholder="-" id="addDuration" type="text"
                                        value="{{ old('duration') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        {{ __('appointment.Title') }}</label>
                                    <input class="primary_input_field" name="certificate[${countCertificate}][title]"
                                        placeholder="-" id="addTitle" type="text"
                                        value="{{ old('title') }}">
                                </div>
                            </div>

                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        {{ __('appointment.Institute') }}</label>
                                    <input class="primary_input_field" name="certificate[${countCertificate}][institute]"
                                        placeholder="-" id="addInstitute" type="text"
                                        value="{{ old('institute') }}">
                                </div>
                            </div>
                @if (auth()->check() && auth()->user()->role_id == 1)
                <div class="col-xl-1 mt-33">
                    <label class="primary_checkbox d-flex mr-12">
                        <input type="checkbox" id="verified" name="certificate[${countCertificate}][is_verified]"
                                            {{ isset($Verified) ? ($Verified == 1 ? 'checked' : '') : '' }}>
                                        <span class="checkmark me-2"></span>{{ __('appointment.Verified') }}
                </label>
            </div>
@endif
                <div class="col-xl-1 mt-33">
                    <button class="removeCertificateBtn primary-btn icon-only fix-gr-bg fl-r"
                        type="button">
                        <span class="ti-trash"></span> </button>
                </div>
            </div>`;
                $("#copyCertificate").append(newDiv);
            }

            addExperience = () => {
                var countExperience = parseFloat($('#experienceDiv').val()) + 1;
                $('#experienceDiv').val(countExperience);
                var newDiv = `<div class="row">
                            <div class="col-xl-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        {{ __('appointment.Duration (Years)') }}</label>
                                    <input class="primary_input_field" name="experience[${countExperience}][duration]"
                                        placeholder="-" id="addDuration" type="text"
                                        value="{{ old('duration') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        {{ __('appointment.Designation') }}</label>
                                    <input class="primary_input_field" name="experience[${countExperience}][designation]"
                                        placeholder="-" id="addDegree" type="text"
                                        value="{{ old('degree') }}">
                                </div>
                            </div>

                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        {{ __('appointment.Institute') }}</label>
                                    <input class="primary_input_field" name="experience[${countExperience}][institute]"
                                        placeholder="-" id="addInstitute" type="text"
                                        value="{{ old('institute') }}">
                                </div>
                            </div>
                            <div class="col-xl-2 mt-45">
                                <button class="removeWorkExperienceBtn primary-btn icon-only fix-gr-bg fl-r"
                                    type="button">
                                    <span class="ti-trash"></span> </button>
                            </div>
                        </div>`
                $("#copyWorkExperience").append(newDiv);
            }

            addTeachingCategory = () => {
                var countTeachingCategory = parseFloat($('#teachingCategoryDiv').val()) + 1;
                $('#teachingCategoryDiv').val(countTeachingCategory);
                var newDiv = `   <div class="row mt-25">
                            <div class="col-xl-4">
                                <label class="primary_input_label"
                                    for="category">{{ __('courses.Category') }}</label>
                                <select class="primary_select teachingCategory" name="teachingCategory[${countTeachingCategory}][category]" id="teachingCategory" data-serial_id = "${countTeachingCategory}"
                                    {{ $errors->has('category') ? 'autofocus' : '' }}>
                                    <option data-display="{{ __('common.Select') }} {{ __('quiz.Category') }} *"
                                        value="">{{ __('common.Select') }} {{ __('quiz.Category') }} </option>
                                        @if (isset($categories))
                @foreach ($categories as $category)
                <option value="{{ $category->id }}">{{ @$category->name }} </option>
                                            @endforeach
                @endif
                </select>
            </div>

            <div class="col-xl-4 courseBox mt-30 teachingSubCategoryDiv" id="teachingSubCategoryDiv_${countTeachingCategory}">
                                <select class="primary_select teachingSubCategory" name="teachingCategory[${countTeachingCategory}][sub_category]" id="teachingSubCategory_${countTeachingCategory}"
                                    {{ $errors->has('sub_category') ? 'autofocus' : '' }}>
                                    <option
                                        data-display="{{ __('common.Select') }} {{ __('courses.Sub Category') }}  "
                                        value="">{{ __('common.Select') }} {{ __('courses.Sub Category') }}
                </option>
            </select>
        </div>

        <div class="col-xl-3">
            <label class="primary_input_label"
                for="category">{{ __('courses.Level') }}</label>
                                <select class="primary_select" name="teachingCategory[${countTeachingCategory}][level]" id="category">
                                    <option data-display="{{ __('appointment.Select Level') }}" value="">
                                        {{ __('appointment.Select Level') }}</option>
                                        @isset($levels)
                @foreach ($levels as $level)
                <option value="{{ $level->id }}">{{ @$level->title }} </option>
                                            @endforeach
                @endisset
                </select>
            </div>
            <div class="col-xl-1 mt-45">
                <button class="removeTeachingCategoryBtn primary-btn icon-only fix-gr-bg fl-r"
                    type="button">
                    <span class="ti-trash"></span> </button>
            </div>
        </div>`;
                $("#copyTeachingCategory").append(newDiv);
                $('.primary_select').niceSelect('destroy');
                $(".primary_select").niceSelect();
            }

            addTeachingLanguage = () => {
                var countTeachingLanguage = parseFloat($('#teachingLanguageDiv').val()) + 1;
                $('#teachingLanguageDiv').val(countTeachingLanguage);
                var newDiv = ` <div class="row mt-25">
                            <div class="col-xl-6">
                                <label class="primary_input_label"
                                    for="category">{{ __('common.Language') }}</label>
                                <select class="primary_select" name="teachingLanguage[${countTeachingLanguage}][language]" id="language">
                                    <option data-display="{{ __('common.Select Language') }}"
                                        value="">{{ __('common.Select Language') }}</option>
                                        @isset($languages)
                @foreach ($languages as $lang)
                <option value="{{ $lang->id }}">{{ @$lang->name }} </option>
                                            @endforeach
                @endisset
                </select>
            </div>
            <div class="col-xl-5">
                <label class="primary_input_label"
                    for="category">{{ __('courses.Level') }}</label>
                                <select class="primary_select" name="teachingLanguage[${countTeachingLanguage}][level]" id="langauageLevel[]">
                                    <option data-display="{{ __('appointment.Select Level') }}" value="">
                                        {{ __('appointment.Select Level') }}</option>
                                        @isset($levels)
                @foreach ($levels as $level)
                <option value="{{ $level->id }}">{{ @$level->title }} </option>
                                            @endforeach
                @endisset
                </select>
            </div>
            <div class="col-xl-1 mt-45">
                <button class="removeTeachingLanguageBtn primary-btn icon-only fix-gr-bg fl-r"
                    type="button">
                    <span class="ti-trash"></span> </button>
            </div>
        </div>`;
                $("#copyTeachingLanguage").append(newDiv);
                $('.primary_select').niceSelect('destroy');
                $(".primary_select").niceSelect();
            }
            addSocialMedia = () => {
                var countSocialMedia = parseFloat($('#educationDiv').val()) + 1;
                $('#educationDiv').val(countSocialMedia);
                var newDiv = `<div class="row">
                            <div class="col-xl-4">
                                <div class="primary_input mb-25">
                                        <label class="primary_input_label" for="">{{ __('frontendmanage.Icon') }} <strong
                                            class="text-danger">*</strong></label>
                                    <select
                                        class="primary_select mb-25  {{ @$errors->has('icon') ? ' is-invalid' : '' }}"
                                        name="social[${countSocialMedia}][icon]" id="icon" required>
                                        {!! socialIconList() !!}
                </select>
            </div>
        </div>

        <div class="col-xl-7">
            <div class="primary_input mb-25">
                <label class="primary_input_label" for=""> {{ __('common.URL') }}</label>
                                    <input class="primary_input_field" name="social[${countSocialMedia}][url]" placeholder="-" id="addFacebook"
                                        type="text" >
                                </div>
                            </div>
                            <div class="col-xl-1 mt-33">
                                    <button class="removeSocialMediaBtn primary-btn icon-only fix-gr-bg fl-r"
                                        type="button">
                                        <span class="ti-trash"></span> </button>
                                </div>
                        </div>`;
                $("#copySocialMedia").append(newDiv);
                $('.primary_select').niceSelect('destroy');
                $(".primary_select").niceSelect();
            }
            $(document).on("click", '.removeEducationBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeCertificateBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeWorkExperienceBtn', function (e) {
                $(this).parent().parent().remove();
            });

            $(document).on("click", '.removeTeachingCategoryBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeTeachingLanguageBtn', function (e) {
                $(this).parent().parent().remove();
            });
            $(document).on("click", '.removeSocialMediaBtn', function (e) {
                $(this).parent().parent().remove();
            });

            $('.cityList').select2({
                ajax: {
                    url: '{{ route('ajaxCounterCity') }}',
                    type: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            search: params.term,
                            page: params.page || 1,
                            id: $('#state').find(':selected').val(),
                        }
                        return query;
                    },
                    cache: false
                }
            });

            $('.stateList').select2({
                ajax: {
                    url: '{{ route('ajaxCounterState') }}',
                    type: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            search: params.term,
                            page: params.page || 1,
                            id: $('#country').find(':selected').val(),
                        }
                        return query;
                    },
                    cache: false
                }
            });


        })(jQuery);
    </script>
@endpush
