<?php

namespace Modules\Assignment\Http\Controllers;

use Carbon\Carbon;
use App\LessonComplete;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use Modules\CourseSetting\Entities\Lesson;
use Modules\Assignment\Entities\InfixAssignment;
use Modules\Assignment\Entities\InfixAssignAssignment;
use Modules\Assignment\Entities\InfixSubmitAssignment;

class AssignAssignmentMarkingController extends Controller
{
    public function submitAssignment(Request $request)
    {
        $validate_rules = [
            'answer' => 'required',
        ];
        $request->validate($validate_rules, validationMessage($validate_rules));
        try {

            $file_upload = new InfixSubmitAssignment();
            if ($request->file('attached_file') != "") {
                $file = $request->file('attached_file');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move('public/uploads/courses/', $fileName);
                $fileName = 'public/uploads/courses/' . $fileName;
                $file_upload->file = $fileName;
            }
            $file_upload->student_id = Auth::user()->id;
            $file_upload->assignment_id = $request->assignment_id;
            $file_upload->answer = $request->answer;
            $file_upload->assignment_from = $request->assignment_from;
            if ($request->assignment_from == 2) {
                $assign_info = InfixAssignAssignment::where('assignment_id', $request->assignment_id)->where('student_id', Auth::user()->id)->first();
                if ($assign_info == null) {
                    $assign_info = new InfixAssignAssignment();
                    $assign_info->assignment_id = $request->assignment_id;
                    $assign_info->student_id = Auth::user()->id;
                    $assign_info->save();
                }
                $file_upload->assign_id = $assign_info->id;
            } else {
                $file_upload->assign_id = $request->assign_id;
            }


            $file_upload->save();
            $assignment_info = InfixAssignment::find($request->assignment_id);


            send_email($assignment_info->creator_info, 'Student_Submit_Assignment', [
                'time' => Carbon::now()->format('d-M-Y ,s:i A'),
                'student' => Auth::user()->name,
                'assignment' => $assignment_info->title,
            ]);

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function assignmentMarking($id)
    {
        try {
            $assigned = InfixAssignAssignment::where('assignment_id', $id)->get();
            $assignment_info = InfixAssignment::find($id);
            return view('assignment::assignment_enrolled_list', compact('assigned', 'assignment_info'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function courseAssignmentMarking($id)
    {
        try {
            $assigned = InfixSubmitAssignment::where('assignment_id', $id)->where('assignment_from', 2)->get();
            $assignment_info = InfixAssignment::find($id);
            // return $assigned;
            return view('assignment::course_assignment_enrolled_list', compact('assigned', 'assignment_info'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function saveAssignmentMarks(Request $request)
    {
        try {
            $validate_rules = [
                'marks' => 'required',
            ];
            $request->validate($validate_rules, validationMessage($validate_rules));


            $assigned = InfixAssignAssignment::find($request->assign_id);

            if (empty($assigned) && isModuleActive('Homework')) {
                $homeworkController = new \Modules\Homework\Http\Controllers\AssignAssignmentMarkingController();
                $homeworkController->saveAssignmentMarks($request);
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            }

            $assignment = InfixAssignment::find($assigned->assignment_id);
            $submitted = InfixSubmitAssignment::find($request->submit_info);

            $min_pass_marks = $assignment->marks * $assignment->min_parcentage / 100;

            if ($request->marks >= $min_pass_marks) {
                $assigned->obtain_marks = $request->marks;
                $assigned->pass_status = 1;
                $result_status = 'Pass';

                $submitted->marks = $request->marks;
                $submitted->is_marked = 1;
                $submitted->marked_by = Auth::user()->id;
                if ($assignment->assignment_from == 2) {
                    $lesson_info = Lesson::where('assignment_id', $assignment->id)->first();

                    $lesson_complete = LessonComplete::where('course_id', $lesson_info->course_id)
                        ->where('lesson_id', $lesson_info->id)
                        ->where('user_id', $assigned->student_id)
                        ->first();
                    if ($lesson_complete == null) {
                        $lesson_complete = new LessonComplete();
                        $lesson_complete->course_id = $lesson_info->course_id;
                        $lesson_complete->lesson_id = $lesson_info->id;
                        $lesson_complete->user_id = $assigned->student_id;
                        $lesson_complete->status = 1;
                        $lesson_complete->save();

                        if (getPercentage($request->marks, $assignment->marks) >= 90) {
                            checkGamification('each_perfectionism ', 'perfectionism', $assignment->student, isModuleActive('Org') ? $lesson_info->course->org_leaderboard_point : 0);
                        }
                        checkGamification('each_assignment_complete', 'assignment', $assignment->student);

                    }
                }
            } else {
                 $result_status = 'Fail';
                $assigned->obtain_marks = $request->marks;
                $assigned->pass_status = 2;

                $submitted->marks = $request->marks;
                $submitted->is_marked = 1;
                $submitted->marked_by = Auth::user()->id;
            }

            $assigned->save();
            $submitted->save();

             send_email($assigned->student, 'Teacher_Marked_Assignment ', [
                'time' => Carbon::now()->format('d-M-Y ,s:i A'),
                'marks' => $request->marks,
                'status' => $result_status,
                'assignment' => $assignment->title,
            ]);

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }
}
